/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ElementsToArray
extends Transformer {
    public ElementsToArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.arrayOf(this.input));
        this.input.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ElementsToArray newObject = (ElementsToArray)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.arrayOf(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int size = this.input.getWidth();
        Token[] valueArray = new Token[size];
        int i = 0;
        while (i < size) {
            valueArray[i] = this.input.get(i);
            ++i;
        }
        this.output.send(0, new ArrayToken(this.input.getType(), valueArray));
    }

    public boolean prefire() throws IllegalActionException {
        int i = 0;
        while (i < this.input.getWidth()) {
            if (!this.input.hasToken(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

