/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class Distributor
extends Transformer
implements SequenceActor {
    public Parameter blockSize = new Parameter(this, "blockSize");
    public Parameter input_tokenConsumptionRate;
    public Parameter output_tokenProductionRate;
    private int _currentOutputPosition;
    private int _tentativeOutputPosition;

    public Distributor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.blockSize.setTypeEquals(BaseType.INT);
        this.blockSize.setExpression("1");
        this.input_tokenConsumptionRate = new Parameter((NamedObj)this.input, "tokenConsumptionRate", new IntToken(0));
        this.input_tokenConsumptionRate.setVisibility(Settable.NOT_EDITABLE);
        this.input_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setPersistent(false);
        this.output_tokenProductionRate = new Parameter(this.output, "tokenProductionRate");
        this.output_tokenProductionRate.setVisibility(Settable.NOT_EDITABLE);
        this.output_tokenProductionRate.setTypeEquals(BaseType.INT);
        this.output_tokenProductionRate.setExpression("blockSize");
        this.output_tokenProductionRate.setPersistent(false);
        this.output.setMultiport(true);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Distributor newObject = (Distributor)super.clone(workspace);
        newObject.input_tokenConsumptionRate = (Parameter)newObject.input.getAttribute("tokenConsumptionRate");
        return newObject;
    }

    public void connectionsChanged(Port port) {
        super.connectionsChanged(port);
        if (port == this.output) {
            this.input_tokenConsumptionRate.setExpression(String.valueOf(this.output.getWidth()) + " * blockSize");
            this._currentOutputPosition = 0;
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this._tentativeOutputPosition = this._currentOutputPosition;
        int width = this.output.getWidth();
        int blockSizeValue = ((IntToken)this.blockSize.getToken()).intValue();
        int i = 0;
        while (i < width) {
            if (!this.input.hasToken(0, blockSizeValue)) break;
            Token[] tokens = this.input.get(0, blockSizeValue);
            this.output.send(this._tentativeOutputPosition++, tokens, blockSizeValue);
            if (this._tentativeOutputPosition >= width) {
                this._tentativeOutputPosition = 0;
            }
            ++i;
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._currentOutputPosition = 0;
    }

    public boolean postfire() throws IllegalActionException {
        this._currentOutputPosition = this._tentativeOutputPosition;
        return super.postfire();
    }
}

