/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.TimedSource;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class CurrentTime
extends TimedSource {
    public CurrentTime(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
    }

    public void fire() throws IllegalActionException {
        double currentTimeValue = Double.POSITIVE_INFINITY;
        if (this.trigger.getWidth() > 0) {
            int i = 0;
            while (i < this.trigger.getWidth()) {
                if (this.trigger.hasToken(i)) {
                    currentTimeValue = Math.min(currentTimeValue, this.trigger.getModelTime(i).getDoubleValue());
                    this.output.send(0, new DoubleToken(currentTimeValue));
                }
                ++i;
            }
        } else {
            currentTimeValue = this.getDirector().getModelTime().getDoubleValue();
            this.output.send(0, new DoubleToken(currentTimeValue));
        }
        super.fire();
    }
}

