/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.Iterator;
import java.util.List;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class BusAssembler
extends TypedAtomicActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    int _outputWidth = 0;

    public BusAssembler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:black\"/>\n</svg>\n");
    }

    public void connectionsChanged(Port p) {
        super.connectionsChanged(p);
        if (p == this.output) {
            return;
        }
        try {
            this._recalculateOutputWidth();
        }
        catch (IllegalActionException illegalActionException) {}
    }

    public void fire() throws IllegalActionException {
        super.fire();
        Iterator inputPorts = this.inputPortList().iterator();
        TypedIOPort inputPort = inputPorts.hasNext() ? inputPorts.next() : null;
        int inputWidth = inputPort != null ? inputPort.getWidth() : 0;
        int i = 0;
        int j = 0;
        while (inputPort != null) {
            if (i < inputWidth && inputPort.hasToken(i)) {
                Token t = inputPort.get(i);
                if (j < this._outputWidth) {
                    this.output.send(j, t);
                }
            }
            ++j;
            if (++i < inputWidth) continue;
            inputPort = inputPorts.hasNext() ? inputPorts.next() : null;
            inputWidth = inputPort != null ? inputPort.getWidth() : 0;
            i = 0;
        }
    }

    public void preinitialize() throws IllegalActionException {
        if (this.outputPortList().size() > 1) {
            throw new IllegalActionException((Nameable)this, "can have only one output port.");
        }
        if (this.output.linkedRelationList().size() > 1) {
            throw new IllegalActionException((Nameable)this, "can have only one output relation linked.");
        }
        this._recalculateOutputWidth();
        super.preinitialize();
    }

    private void _recalculateOutputWidth() throws IllegalActionException {
        List outputRelations = this.output.linkedRelationList();
        this._outputWidth = 0;
        if (outputRelations.isEmpty()) {
            return;
        }
        TypedIORelation outputRelation = (TypedIORelation)outputRelations.get(0);
        for (TypedIOPort port : this.inputPortList()) {
            this._outputWidth += port.getWidth();
        }
        outputRelation.setWidth(this._outputWidth);
    }
}

