/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ArraySum
extends Transformer {
    public ArraySum(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType(this.input));
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArraySum newObject = (ArraySum)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.input.get(0);
            if (token.length() == 0) {
                return;
            }
            Token sum = token.getElement(0);
            int i = 1;
            while (i < token.length()) {
                sum = sum.add(token.getElement(i));
                ++i;
            }
            this.output.send(0, sum);
        }
    }
}

