/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ArrayRemoveElement
extends TypedAtomicActor {
    public TypedIOPort array = new TypedIOPort(this, "array", true, false);
    public TypedIOPort output;
    public PortParameter element;

    public ArrayRemoveElement(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        new Parameter((NamedObj)this.array, "_showName", BooleanToken.TRUE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.element = new PortParameter(this, "element");
        new Parameter((NamedObj)this.element.getPort(), "_showName", BooleanToken.TRUE);
        this.array.setTypeAtLeast(ArrayType.arrayOf(this.element));
        this.output.setTypeAtLeast(this.array);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayRemoveElement newObject = (ArrayRemoveElement)super.clone(workspace);
        try {
            newObject.array.setTypeAtLeast(ArrayType.arrayOf(newObject.element));
            newObject.output.setTypeAtLeast(newObject.array);
        }
        catch (IllegalActionException e) {
            throw new CloneNotSupportedException("Clone failed: " + e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        this.element.update();
        Token elementToken = this.element.getToken();
        if (this.array.hasToken(0)) {
            ArrayToken inputArray = (ArrayToken)this.array.get(0);
            Token[] outputElements = new Token[inputArray.length()];
            int outputSize = 0;
            int i = 0;
            while (i < inputArray.length()) {
                Token inputElement = inputArray.getElement(i);
                if (!elementToken.equals(inputElement)) {
                    outputElements[outputSize] = inputElement;
                    ++outputSize;
                }
                ++i;
            }
            ArrayToken result = null;
            if (outputSize > 0) {
                Token[] copy = new Token[outputSize];
                System.arraycopy(outputElements, 0, copy, 0, outputSize);
                result = new ArrayToken(copy);
            } else {
                result = new ArrayToken(inputArray.getElementType());
            }
            this.output.broadcast(result);
        }
    }
}

