/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ArrayExtract
extends Transformer {
    public PortParameter sourcePosition;
    public PortParameter extractLength;
    public PortParameter destinationPosition;
    public PortParameter outputArrayLength;

    public ArrayExtract(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.output.setTypeAtLeast(this.input);
        this.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
        this.sourcePosition = new PortParameter(this, "sourcePosition");
        this.sourcePosition.setExpression("0");
        this.extractLength = new PortParameter(this, "extractLength");
        this.extractLength.setExpression("1");
        this.destinationPosition = new PortParameter(this, "destinationPosition");
        this.destinationPosition.setExpression("0");
        this.outputArrayLength = new PortParameter(this, "outputArrayLength");
        this.outputArrayLength.setExpression("1");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayExtract newObject = (ArrayExtract)super.clone(workspace);
        newObject.input.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newObject.output.setTypeAtLeast(newObject.input);
        newObject.output.setTypeAtLeast(ArrayType.ARRAY_UNSIZED_BOTTOM);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.sourcePosition.update();
        this.extractLength.update();
        this.destinationPosition.update();
        this.outputArrayLength.update();
        if (this.input.hasToken(0)) {
            ArrayToken inputValue = (ArrayToken)this.input.get(0);
            Type inputElementType = inputValue.getElementType();
            Token[] inputArray = inputValue.arrayValue();
            int sourcePositionValue = ((IntToken)this.sourcePosition.getToken()).intValue();
            int extractLengthValue = ((IntToken)this.extractLength.getToken()).intValue();
            int destinationPositionValue = ((IntToken)this.destinationPosition.getToken()).intValue();
            int outputArrayLengthValue = ((IntToken)this.outputArrayLength.getToken()).intValue();
            try {
                Token[] outputArray = new Token[outputArrayLengthValue];
                Token zero = inputArray[0].zero();
                int i = 0;
                while (i < destinationPositionValue) {
                    outputArray[i] = zero;
                    ++i;
                }
                System.arraycopy(inputArray, sourcePositionValue, outputArray, destinationPositionValue, extractLengthValue);
                i = destinationPositionValue + extractLengthValue;
                while (i < outputArrayLengthValue) {
                    outputArray[i] = zero;
                    ++i;
                }
                this.output.send(0, new ArrayToken(inputElementType, outputArray));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalActionException((Nameable)this, "Parameter values out of range for the array supplied.inputArray has length" + inputArray.length);
            }
        }
    }
}

