/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ArrayContains
extends TypedAtomicActor {
    public TypedIOPort array = new TypedIOPort(this, "array", true, false);
    public TypedIOPort output;
    public PortParameter element;

    public ArrayContains(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        new Parameter((NamedObj)this.array, "_showName", BooleanToken.TRUE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.element = new PortParameter(this, "element");
        new Parameter((NamedObj)this.element.getPort(), "_showName", BooleanToken.TRUE);
        this.array.setTypeAtLeast(ArrayType.arrayOf(this.element));
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayContains newObject = (ArrayContains)super.clone(workspace);
        try {
            newObject.array.setTypeAtLeast(ArrayType.arrayOf(newObject.element));
        }
        catch (IllegalActionException e) {
            throw new CloneNotSupportedException("Clone failed: " + e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        this.element.update();
        Token elementToken = this.element.getToken();
        if (this.array.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.array.get(0);
            boolean contained = false;
            int i = 0;
            while (i < token.length()) {
                BooleanToken bt = elementToken.isEqualTo(token.getElement(i));
                if (bt.booleanValue()) {
                    contained = true;
                    break;
                }
                ++i;
            }
            this.output.broadcast(new BooleanToken(contained));
        }
    }
}

