/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.List;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ScalarToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class AbsoluteValue
extends Transformer {
    public AbsoluteValue(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(new FunctionTerm(this.input));
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        AbsoluteValue newObject = (AbsoluteValue)super.clone(workspace);
        newObject.output.setTypeAtLeast(new FunctionTerm(newObject.input));
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            ScalarToken in = (ScalarToken)this.input.get(0);
            this.output.send(0, in.absolute());
        }
    }

    public List typeConstraintList() {
        return this.output.typeConstraintList();
    }

    private static class FunctionTerm
    extends MonotonicFunction {
        private TypedIOPort _port;

        private FunctionTerm(TypedIOPort port) {
            this._port = port;
        }

        public Object getValue() {
            Type inputType = this._port.getType();
            if (inputType == BaseType.COMPLEX) {
                return BaseType.DOUBLE;
            }
            if (inputType == BaseType.COMPLEX_MATRIX) {
                return BaseType.DOUBLE_MATRIX;
            }
            return inputType;
        }

        public InequalityTerm[] getVariables() {
            if (this._port.getTypeTerm().isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this._port.getTypeTerm()};
                return variable;
            }
            return new InequalityTerm[0];
        }
    }
}

