/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypeAttribute;
import ptolemy.actor.TypeEvent;
import ptolemy.actor.TypeListener;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeConstant;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.type.Typeable;
import ptolemy.graph.CPO;
import ptolemy.graph.Inequality;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class TypedIOPort
extends IOPort
implements Typeable {
    public static final int TYPE = 4096;
    private Type _declaredType = BaseType.UNKNOWN;
    private Type _resolvedType = BaseType.UNKNOWN;
    private TypeTerm _typeTerm = null;
    private List _typeListeners = new LinkedList();
    private List _constraints = new LinkedList();

    public TypedIOPort() {
    }

    public TypedIOPort(Workspace workspace) {
        super(workspace);
    }

    public TypedIOPort(ComponentEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public TypedIOPort(ComponentEntity container, String name, boolean isInput, boolean isOutput) throws IllegalActionException, NameDuplicationException {
        super(container, name, isInput, isOutput);
    }

    public void addTypeListener(TypeListener listener) {
        if (!this._typeListeners.contains(listener)) {
            this._typeListeners.add(listener);
        }
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute instanceof TypeAttribute) {
            Type type = ((TypeAttribute)attribute).getType();
            if (!(type == null || type.equals(this._declaredType) && type.equals(this._resolvedType))) {
                this.setTypeEquals(type);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void broadcast(Token token) throws IllegalActionException, NoRoomException {
        this._checkType(token);
        super.broadcast(token);
    }

    public void broadcast(Token[] tokenArray, int vectorLength) throws IllegalActionException, NoRoomException {
        int i = 0;
        while (i < tokenArray.length) {
            Token token = tokenArray[i];
            this._checkType(token);
            ++i;
        }
        super.broadcast(tokenArray, vectorLength);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        TypedIOPort newObject = (TypedIOPort)super.clone(workspace);
        if (this._declaredType instanceof StructuredType && !this._declaredType.isConstant()) {
            newObject._resolvedType = newObject._declaredType = (Type)((StructuredType)this._declaredType).clone();
        }
        newObject._typeTerm = null;
        newObject._typeListeners = new LinkedList();
        newObject._constraints = new LinkedList();
        return newObject;
    }

    public Token convert(Token token) throws IllegalActionException {
        Type type = this.getType();
        if (type.equals(token.getType())) {
            return token;
        }
        try {
            Token newToken = type.convert(token);
            return newToken;
        }
        catch (IllegalActionException illegalActionException) {
            return token;
        }
    }

    public Type getType() {
        try {
            this._workspace.getReadAccess();
            Type result = BaseType.UNKNOWN;
            if (this.isOpaque()) {
                result = this._resolvedType;
            } else if (this.isInput()) {
                Receiver[][] receivers = this.deepGetReceivers();
                LinkedList<Type> portTypeList = new LinkedList<Type>();
                if (receivers != null) {
                    int i = 0;
                    while (i < receivers.length) {
                        if (receivers[i] != null) {
                            int j = 0;
                            while (j < receivers[i].length) {
                                TypedIOPort port = (TypedIOPort)receivers[i][j].getContainer();
                                portTypeList.add(port.getType());
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                CPO lattice = TypeLattice.lattice();
                Object[] portTypeArray = portTypeList.toArray();
                result = (Type)lattice.greatestLowerBound(portTypeArray);
            } else if (this.isOutput()) {
                Iterator ports = this.deepInsidePortList().iterator();
                LinkedList<Type> portTypeList = new LinkedList<Type>();
                while (ports.hasNext()) {
                    TypedIOPort port = (TypedIOPort)ports.next();
                    if (port == this || !port.isOutput()) continue;
                    portTypeList.add(port.getType());
                }
                CPO lattice = TypeLattice.lattice();
                Object[] portTypeArray = portTypeList.toArray();
                result = (Type)lattice.leastUpperBound(portTypeArray);
            }
            Type type = result;
            return type;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public InequalityTerm getTypeTerm() {
        if (this._typeTerm == null) {
            this._typeTerm = new TypeTerm();
        }
        return this._typeTerm;
    }

    public boolean isTypeAcceptable() {
        if (this.getType().isInstantiable()) {
            return true;
        }
        if (this.numLinks() == 0) {
            return true;
        }
        return this.isInput() && !this.isOutput() && this.numberOfSources() == 0;
    }

    public void removeTypeListener(TypeListener listener) {
        if (this._typeListeners.contains(listener)) {
            this._typeListeners.remove(listener);
        }
    }

    public void send(int channelIndex, Token token) throws IllegalActionException, NoRoomException {
        this._checkType(token);
        super.send(channelIndex, token);
    }

    public void send(int channelIndex, Token[] tokenArray, int vectorLength) throws IllegalActionException, NoRoomException {
        int i = 0;
        while (i < vectorLength) {
            Token token = tokenArray[i];
            this._checkType(token);
            ++i;
        }
        super.send(channelIndex, tokenArray, vectorLength);
    }

    public void sendInside(int channelIndex, Token token) throws IllegalActionException, NoRoomException {
        this._checkType(token);
        super.sendInside(channelIndex, token);
    }

    public void setTypeAtLeast(Typeable lesser) {
        Inequality inequality = new Inequality(lesser.getTypeTerm(), this.getTypeTerm());
        this._constraints.add(inequality);
    }

    public void setTypeAtLeast(InequalityTerm typeTerm) {
        Inequality inequality = new Inequality(typeTerm, this.getTypeTerm());
        this._constraints.add(inequality);
    }

    public void setTypeAtMost(Type type) {
        Inequality inequality = new Inequality(this.getTypeTerm(), new TypeConstant(type));
        this._constraints.add(inequality);
    }

    public void setTypeEquals(Type type) {
        try {
            this._workspace.getWriteAccess();
            try {
                this._declaredType = (Type)type.clone();
            }
            catch (CloneNotSupportedException cloneNotSupported) {
                throw new InternalErrorException(this, (Throwable)cloneNotSupported, "TypedIOPort.setTypeEquals: Cannot clone type");
            }
            Type oldType = this._resolvedType;
            this._resolvedType = this._declaredType;
            if (!oldType.equals(this._declaredType)) {
                this._notifyTypeListener(oldType, this._declaredType);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void setTypeSameAs(Typeable equal) {
        Inequality inequality = new Inequality(this.getTypeTerm(), equal.getTypeTerm());
        this._constraints.add(inequality);
        inequality = new Inequality(equal.getTypeTerm(), this.getTypeTerm());
        this._constraints.add(inequality);
    }

    public List typeConstraintList() {
        return this._constraints;
    }

    protected void _checkContainer(Entity container) throws IllegalActionException {
        if (!(container instanceof TypedActor) && container != null) {
            throw new IllegalActionException((Nameable)container, this, "TypedIOPort can only be contained by objects implementing the TypedActor interface.");
        }
    }

    protected void _checkLiberalLink(ComponentRelation relation) throws IllegalActionException {
        if (!(relation instanceof TypedIORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "Attempt to link to an incompatible relation. TypedIOPort requires TypedIORelation.");
        }
        super._checkLiberalLink(relation);
    }

    protected void _checkLink(Relation relation) throws IllegalActionException {
        if (!(relation instanceof TypedIORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "Attempt to link to an incompatible relation. TypedIOPort requires TypedIORelation.");
        }
        super._checkLink(relation);
    }

    protected void _checkType(Token token) throws IllegalActionException {
        int compare = TypeLattice.compare(token.getType(), this._resolvedType);
        if (compare == 1 || compare == 2) {
            throw new IllegalActionException((Nameable)this, "Run-time type checking failed. Token " + token + " with type " + token.getType() + " is incompatible with port type: " + this.getType().toString());
        }
    }

    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            String result = bracket == 1 || bracket == 2 ? super._description(detail, indent, 1) : super._description(detail, indent, 0);
            if ((detail & 0x1000) != 0) {
                if (result.trim().length() > 0) {
                    result = String.valueOf(result) + " ";
                }
                result = String.valueOf(result) + "type {declared ";
                result = String.valueOf(result) + this._declaredType.toString();
                result = String.valueOf(result) + " resolved ";
                result = String.valueOf(result) + this.getType().toString();
                result = String.valueOf(result) + "}";
            }
            if (bracket == 2) {
                result = String.valueOf(result) + "}";
            }
            String string = result;
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    private void _notifyTypeListener(Type oldType, Type newType) {
        if (this._typeListeners.size() > 0) {
            TypeEvent event = new TypeEvent(this, oldType, newType);
            Iterator listeners = this._typeListeners.iterator();
            while (listeners.hasNext()) {
                ((TypeListener)listeners.next()).typeChanged(event);
            }
        }
    }

    private class TypeTerm
    implements InequalityTerm {
        private TypeTerm() {
        }

        public Object getAssociatedObject() {
            return TypedIOPort.this;
        }

        public Object getValue() {
            return TypedIOPort.this.getType();
        }

        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        public void initialize(Object type) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("TypeTerm.initialize: Cannot initialize a constant type.");
            }
            if (!(type instanceof Type)) {
                throw new IllegalActionException("TypeTerm.initialize: The argument is not a Type.");
            }
            Type oldType = TypedIOPort.this._resolvedType;
            if (TypedIOPort.this._declaredType == BaseType.UNKNOWN) {
                TypedIOPort.this._resolvedType = (Type)type;
            } else {
                ((StructuredType)TypedIOPort.this._resolvedType).initialize((Type)type);
            }
            if (!oldType.equals(TypedIOPort.this._resolvedType)) {
                TypedIOPort.this._notifyTypeListener(oldType, TypedIOPort.this._resolvedType);
            }
        }

        public boolean isSettable() {
            return !TypedIOPort.this._declaredType.isConstant();
        }

        public boolean isValueAcceptable() {
            return TypedIOPort.this.isTypeAcceptable();
        }

        public void setValue(Object type) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("TypedIOPort$TypeTerm.setValue: The type is not settable.");
            }
            if (!TypedIOPort.this._declaredType.isSubstitutionInstance((Type)type)) {
                throw new IllegalActionException("Type conflict on port " + TypedIOPort.this.getFullName() + ".\n" + "Declared type is " + TypedIOPort.this._declaredType.toString() + ".\n" + "The connection or type constraints, however, " + "require type " + type.toString());
            }
            Type oldType = TypedIOPort.this._resolvedType;
            if (TypedIOPort.this._declaredType == BaseType.UNKNOWN) {
                TypedIOPort.this._resolvedType = (Type)type;
            } else {
                ((StructuredType)TypedIOPort.this._resolvedType).updateType((StructuredType)type);
            }
            if (!oldType.equals(type)) {
                TypedIOPort.this._notifyTypeListener(oldType, TypedIOPort.this._resolvedType);
            }
        }

        public String toString() {
            return "(" + TypedIOPort.this.toString() + ", " + TypedIOPort.this.getType() + ")";
        }
    }
}

