/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.TypeConflictException;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.ExceptionHandler;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.PtolemyThread;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class Manager
extends NamedObj
implements Runnable {
    public static final State CORRUPTED = new State("corrupted");
    public static final State IDLE = new State("idle");
    public static final State INITIALIZING = new State("initializing");
    public static final State ITERATING = new State("executing");
    public static final State PAUSED = new State("pausing execution");
    public static final State PAUSED_ON_BREAKPOINT = new State("pausing execution on a breakpoint");
    public static final State PREINITIALIZING = new State("preinitializing");
    public static final State RESOLVING_TYPES = new State("resolving types");
    public static final State THROWING_A_THROWABLE = new State("throwing a throwable");
    public static final State WRAPPING_UP = new State("wrapping up");
    public static final State EXITING = new State("exiting");
    private List _actorsToInitialize = new LinkedList();
    private CompositeActor _container = null;
    private List _executionListeners;
    private boolean _exitAfterWrapup = false;
    private boolean _finishRequested = false;
    private int _iterationCount;
    private HashMap _nameToAnalysis;
    private boolean _pauseRequested = false;
    private boolean _resumeNotifyWaiting = false;
    private State _state = IDLE;
    private PtolemyThread _thread;
    private boolean _typesResolved = false;

    public Manager() {
    }

    public Manager(String name) throws IllegalActionException {
        super(name);
    }

    public Manager(Workspace workspace, String name) throws IllegalActionException {
        super(workspace, name);
    }

    public void addAnalysis(String name, Object analysis) {
        if (this._nameToAnalysis == null) {
            this._nameToAnalysis = new HashMap();
        }
        this._nameToAnalysis.put(name, analysis);
    }

    public void addExecutionListener(ExecutionListener listener) {
        if (listener == null) {
            return;
        }
        if (this._executionListeners == null) {
            this._executionListeners = new LinkedList();
        }
        this._executionListeners.add(new WeakReference<ExecutionListener>(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute() throws KernelException, IllegalActionException {
        block86: {
            block82: {
                block84: {
                    block83: {
                        block78: {
                            block85: {
                                block79: {
                                    block81: {
                                        block80: {
                                            var1_1 = this;
                                            synchronized (var1_1) {
                                                if (this._state != Manager.IDLE) {
                                                    throw new IllegalActionException((Nameable)this, "Model is already running.");
                                                }
                                            }
                                            startTime = new Date().getTime();
                                            this._debug("-- Manager execute() called.");
                                            this._finishRequested = false;
                                            completedSuccessfully = false;
                                            initialThrowable = null;
                                            try {
                                                try {
                                                    this.initialize();
                                                    if (System.currentTimeMillis() - startTime > 60000L) {
                                                        System.out.println("Manager.initialize() finished: " + Manager.timeAndMemory(startTime));
                                                    }
                                                    this._debug("-- Manager beginning to iterate.");
                                                    while (!this._finishRequested) {
                                                        if (!this.iterate()) break;
                                                        if (!this._pauseRequested) continue;
                                                        var5_5 = this;
                                                        synchronized (var5_5) {
                                                            this._setState(Manager.PAUSED);
                                                            while (this._pauseRequested && !this._finishRequested) {
                                                                try {
                                                                    this.wait();
                                                                }
                                                                catch (InterruptedException v1) {}
                                                            }
                                                        }
                                                    }
                                                    completedSuccessfully = true;
                                                }
                                                catch (Throwable throwable) {
                                                    this._setState(Manager.THROWING_A_THROWABLE);
                                                    initialThrowable = throwable;
                                                }
                                                break block78;
                                            }
                                            catch (Throwable var6_7) {
                                                try {
                                                    this.wrapup();
                                                    break block79;
                                                }
                                                catch (Exception exception) {
                                                    if (initialThrowable == null) {
                                                        initialThrowable = exception;
                                                    }
                                                    this.setDeferringChangeRequests(false);
                                                    this._finishRequested = false;
                                                    if (this._state != Manager.IDLE) {
                                                        this._setState(Manager.IDLE);
                                                    }
                                                    if (completedSuccessfully) {
                                                        this._notifyListenersOfCompletion();
                                                    }
                                                    System.out.println(Manager.timeAndMemory(startTime));
                                                    if (initialThrowable == null) break block80;
                                                    exceptionHandlersList = this._container.entityList(ExceptionHandler.class);
                                                    exceptionHandlers = exceptionHandlersList.iterator();
                                                    if (exceptionHandlersList.size() <= 0) break block80;
                                                    exceptionHandled = false;
                                                    ** while (exceptionHandlers.hasNext())
                                                }
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                exceptionHandler = (ExceptionHandler)exceptionHandlers.next();
                                                if (!exceptionHandler.handleException(this._container, initialThrowable)) continue;
                                                exceptionHandled = true;
                                                continue;
                                            }
lbl68:
                                            // 1 sources

                                            if (exceptionHandled) {
                                                initialThrowable = null;
                                                this._notifyListenersOfCompletion();
                                            }
                                        }
                                        if (initialThrowable != null) {
                                            if (initialThrowable instanceof RuntimeException) {
                                                throw (RuntimeException)initialThrowable;
                                            }
                                            if (initialThrowable instanceof KernelException) {
                                                throw (KernelException)initialThrowable;
                                            }
                                            if (initialThrowable instanceof RuntimeException) {
                                                throw (RuntimeException)initialThrowable;
                                            }
                                            throw new IllegalActionException((Nameable)this, initialThrowable, null);
                                        }
                                        break block85;
                                        {
                                            catch (Throwable var8_34) {
                                                this.setDeferringChangeRequests(false);
                                                this._finishRequested = false;
                                                if (this._state != Manager.IDLE) {
                                                    this._setState(Manager.IDLE);
                                                }
                                                if (completedSuccessfully) {
                                                    this._notifyListenersOfCompletion();
                                                }
                                                System.out.println(Manager.timeAndMemory(startTime));
                                                if (initialThrowable == null) break block81;
                                                exceptionHandlersList = this._container.entityList(ExceptionHandler.class);
                                                exceptionHandlers = exceptionHandlersList.iterator();
                                                if (exceptionHandlersList.size() <= 0) break block81;
                                                exceptionHandled = false;
                                                ** while (exceptionHandlers.hasNext())
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            exceptionHandler = (ExceptionHandler)exceptionHandlers.next();
                                            if (!exceptionHandler.handleException(this._container, initialThrowable)) continue;
                                            exceptionHandled = true;
                                            continue;
                                        }
lbl100:
                                        // 1 sources

                                        if (exceptionHandled) {
                                            initialThrowable = null;
                                            this._notifyListenersOfCompletion();
                                        }
                                    }
                                    if (initialThrowable != null) {
                                        if (initialThrowable instanceof RuntimeException) {
                                            throw (RuntimeException)initialThrowable;
                                        }
                                        if (initialThrowable instanceof KernelException) {
                                            throw (KernelException)initialThrowable;
                                        }
                                        if (initialThrowable instanceof RuntimeException) {
                                            throw (RuntimeException)initialThrowable;
                                        }
                                        throw new IllegalActionException((Nameable)this, initialThrowable, null);
                                    }
                                    throw var8_34;
                                }
                                this.setDeferringChangeRequests(false);
                                this._finishRequested = false;
                                if (this._state != Manager.IDLE) {
                                    this._setState(Manager.IDLE);
                                }
                                if (completedSuccessfully) {
                                    this._notifyListenersOfCompletion();
                                }
                                System.out.println(Manager.timeAndMemory(startTime));
                                if (initialThrowable != null) {
                                    exceptionHandlersList = this._container.entityList(ExceptionHandler.class);
                                    exceptionHandlers = exceptionHandlersList.iterator();
                                    if (exceptionHandlersList.size() > 0) {
                                        exceptionHandled = false;
                                        while (exceptionHandlers.hasNext()) {
                                            exceptionHandler = (ExceptionHandler)exceptionHandlers.next();
                                            if (!exceptionHandler.handleException(this._container, initialThrowable)) continue;
                                            exceptionHandled = true;
                                        }
                                        if (exceptionHandled) {
                                            initialThrowable = null;
                                            this._notifyListenersOfCompletion();
                                        }
                                    }
                                }
                                if (initialThrowable != null) {
                                    if (initialThrowable instanceof RuntimeException) {
                                        throw (RuntimeException)initialThrowable;
                                    }
                                    if (initialThrowable instanceof KernelException) {
                                        throw (KernelException)initialThrowable;
                                    }
                                    if (initialThrowable instanceof RuntimeException) {
                                        throw (RuntimeException)initialThrowable;
                                    }
                                    throw new IllegalActionException((Nameable)this, initialThrowable, null);
                                }
                            }
                            throw var6_7;
                        }
                        try {
                            try {
                                this.wrapup();
                                break block82;
                            }
                            catch (Exception exception) {
                                if (initialThrowable == null) {
                                    initialThrowable = exception;
                                }
                                this.setDeferringChangeRequests(false);
                                this._finishRequested = false;
                                if (this._state != Manager.IDLE) {
                                    this._setState(Manager.IDLE);
                                }
                                if (completedSuccessfully) {
                                    this._notifyListenersOfCompletion();
                                }
                                System.out.println(Manager.timeAndMemory(startTime));
                                if (initialThrowable == null) break block83;
                                exceptionHandlersList = this._container.entityList(ExceptionHandler.class);
                                exceptionHandlers = exceptionHandlersList.iterator();
                                if (exceptionHandlersList.size() <= 0) break block83;
                                exceptionHandled = false;
                                ** while (exceptionHandlers.hasNext())
                            }
                        }
                        catch (Throwable var8_35) {
                            this.setDeferringChangeRequests(false);
                            this._finishRequested = false;
                            if (this._state != Manager.IDLE) {
                                this._setState(Manager.IDLE);
                            }
                            if (completedSuccessfully) {
                                this._notifyListenersOfCompletion();
                            }
                            System.out.println(Manager.timeAndMemory(startTime));
                            if (initialThrowable == null) break block84;
                            exceptionHandlersList = this._container.entityList(ExceptionHandler.class);
                            exceptionHandlers = exceptionHandlersList.iterator();
                            if (exceptionHandlersList.size() <= 0) break block84;
                            exceptionHandled = false;
                            ** while (exceptionHandlers.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            exceptionHandler = (ExceptionHandler)exceptionHandlers.next();
                            if (!exceptionHandler.handleException(this._container, initialThrowable)) continue;
                            exceptionHandled = true;
                            continue;
                        }
lbl171:
                        // 1 sources

                        if (exceptionHandled) {
                            initialThrowable = null;
                            this._notifyListenersOfCompletion();
                        }
                    }
                    if (initialThrowable != null) {
                        if (initialThrowable instanceof RuntimeException) {
                            throw (RuntimeException)initialThrowable;
                        }
                        if (initialThrowable instanceof KernelException) {
                            throw (KernelException)initialThrowable;
                        }
                        if (initialThrowable instanceof RuntimeException) {
                            throw (RuntimeException)initialThrowable;
                        }
                        throw new IllegalActionException((Nameable)this, initialThrowable, null);
                    }
                    break block86;
lbl-1000:
                    // 1 sources

                    {
                        exceptionHandler = (ExceptionHandler)exceptionHandlers.next();
                        if (!exceptionHandler.handleException(this._container, initialThrowable)) continue;
                        exceptionHandled = true;
                        continue;
                    }
lbl203:
                    // 1 sources

                    if (exceptionHandled) {
                        initialThrowable = null;
                        this._notifyListenersOfCompletion();
                    }
                }
                if (initialThrowable != null) {
                    if (initialThrowable instanceof RuntimeException) {
                        throw (RuntimeException)initialThrowable;
                    }
                    if (initialThrowable instanceof KernelException) {
                        throw (KernelException)initialThrowable;
                    }
                    if (initialThrowable instanceof RuntimeException) {
                        throw (RuntimeException)initialThrowable;
                    }
                    throw new IllegalActionException((Nameable)this, initialThrowable, null);
                }
                throw var8_35;
            }
            this.setDeferringChangeRequests(false);
            this._finishRequested = false;
            if (this._state != Manager.IDLE) {
                this._setState(Manager.IDLE);
            }
            if (completedSuccessfully) {
                this._notifyListenersOfCompletion();
            }
            System.out.println(Manager.timeAndMemory(startTime));
            if (initialThrowable != null) {
                exceptionHandlersList = this._container.entityList(ExceptionHandler.class);
                exceptionHandlers = exceptionHandlersList.iterator();
                if (exceptionHandlersList.size() > 0) {
                    exceptionHandled = false;
                    while (exceptionHandlers.hasNext()) {
                        exceptionHandler = (ExceptionHandler)exceptionHandlers.next();
                        if (!exceptionHandler.handleException(this._container, initialThrowable)) continue;
                        exceptionHandled = true;
                    }
                    if (exceptionHandled) {
                        initialThrowable = null;
                        this._notifyListenersOfCompletion();
                    }
                }
            }
            if (initialThrowable != null) {
                if (initialThrowable instanceof RuntimeException) {
                    throw (RuntimeException)initialThrowable;
                }
                if (initialThrowable instanceof KernelException) {
                    throw (KernelException)initialThrowable;
                }
                if (initialThrowable instanceof RuntimeException) {
                    throw (RuntimeException)initialThrowable;
                }
                throw new IllegalActionException((Nameable)this, initialThrowable, null);
            }
        }
    }

    public void exitAfterWrapup() {
        this._exitAfterWrapup = true;
        this._setState(EXITING);
    }

    public void finish() {
        this._finishRequested = true;
        if (this._debugging) {
            this._debug("finish() has been called.");
        }
        if (this._state == IDLE) {
            return;
        }
        NamedObj container = this.getContainer();
        if (!(container instanceof CompositeActor)) {
            throw new InternalErrorException("Attempted to call finish() on an executing manager with no associated CompositeActor model");
        }
        ((CompositeActor)container).stop();
        Thread unpauser = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Manager manager = Manager.this;
                synchronized (manager) {
                    Manager.this.notifyAll();
                }
            }
        };
        unpauser.start();
    }

    public Object getAnalysis(String name) {
        if (this._nameToAnalysis == null) {
            return null;
        }
        return this._nameToAnalysis.get(name);
    }

    public NamedObj getContainer() {
        return this._container;
    }

    public int getIterationCount() {
        return this._iterationCount;
    }

    public State getState() {
        return this._state;
    }

    public synchronized void initialize() throws KernelException, IllegalActionException {
        try {
            this._workspace.getReadAccess();
            this.setDeferringChangeRequests(true);
            long startTime = new Date().getTime();
            this.preinitializeAndResolveTypes();
            if (System.currentTimeMillis() - startTime > 60000L) {
                System.out.println("preinitialize() finished: " + Manager.timeAndMemory(startTime));
            }
            this._setState(INITIALIZING);
            this._container.initialize();
            this._actorsToInitialize.clear();
            this.executeChangeRequests();
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void invalidateResolvedTypes() {
        this._typesResolved = false;
    }

    public boolean isExitingAfterWrapup() {
        return this._exitAfterWrapup;
    }

    public boolean iterate() throws KernelException {
        if (this._container == null) {
            throw new IllegalActionException((Nameable)this, "No model to execute!");
        }
        boolean result = true;
        long startTime = new Date().getTime();
        try {
            this._workspace.getReadAccess();
            this.executeChangeRequests();
            if (this._actorsToInitialize.size() > 0) {
                for (Actor actor : this._actorsToInitialize) {
                    if (!((ComponentEntity)((Object)actor)).isOpaque()) continue;
                    actor.preinitialize();
                }
            }
            if (System.currentTimeMillis() - startTime > 60000L) {
                System.out.println("Manager.iterate(): preinitialize() finished: " + Manager.timeAndMemory(startTime));
            }
            if (!this._typesResolved) {
                this.resolveTypes();
                this._typesResolved = true;
            }
            ++this._iterationCount;
            this._setState(ITERATING);
            if (this._actorsToInitialize.size() > 0) {
                for (Actor actor : this._actorsToInitialize) {
                    actor.getExecutiveDirector().initialize(actor);
                }
                this._actorsToInitialize.clear();
            }
            if (this._container.prefire()) {
                this._container.fire();
                result = this._container.postfire();
            }
        }
        finally {
            this._workspace.doneReading();
        }
        return result;
    }

    public void notifyListenersOfException(Exception exception) {
        this.notifyListenersOfThrowable(exception);
    }

    public void notifyListenersOfThrowable(final Throwable throwable) {
        Thread thread = new Thread("Error reporting thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Manager manager = Manager.this;
                synchronized (manager) {
                    String errorMessage = String.valueOf(MessageHandler.shortDescription(throwable)) + " occurred: " + throwable.getClass() + "(" + throwable.getMessage() + ")";
                    Manager.this._debug("-- Manager notifying listeners of exception: " + throwable);
                    if (Manager.this._executionListeners == null) {
                        System.err.println(errorMessage);
                        throwable.printStackTrace();
                    } else {
                        ListIterator listeners = Manager.this._executionListeners.listIterator();
                        while (listeners.hasNext()) {
                            WeakReference reference = (WeakReference)listeners.next();
                            ExecutionListener listener = (ExecutionListener)reference.get();
                            if (listener != null) {
                                listener.executionError(Manager.this, throwable);
                                continue;
                            }
                            listeners.remove();
                        }
                    }
                }
            }
        };
        thread.start();
    }

    public void pause() {
        this._pauseRequested = true;
        NamedObj container = this.getContainer();
        if (!(container instanceof CompositeActor)) {
            throw new InternalErrorException("Attempted to call pause() on an executing manager with no associated CompositeActor model");
        }
        ((CompositeActor)container).stopFire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseOnBreakpoint(String breakpointMessage) {
        block9: {
            try {
                if (this._state == ITERATING) {
                    Manager manager = this;
                    synchronized (manager) {
                        if (this._state == ITERATING) {
                            Manager.PAUSED_ON_BREAKPOINT.setDescription("pausing on breakpoint: " + breakpointMessage + ".  Click Resume to continue.");
                            this._setState(PAUSED_ON_BREAKPOINT);
                            this._resumeNotifyWaiting = true;
                            while (this._resumeNotifyWaiting) {
                                this.wait();
                            }
                        } else {
                            throw new InternalErrorException("State was changed while pauseOnBreakpoint was called.");
                        }
                        this._setState(ITERATING);
                        break block9;
                    }
                }
                throw new InternalErrorException("pauseOnBreakpoint occurred while not iterating the model.");
            }
            catch (InterruptedException interruptedException) {
                throw new InternalErrorException("Interrupted while trying to wait for resume() method to be called.");
            }
        }
    }

    public synchronized void preinitializeAndResolveTypes() throws KernelException {
        try {
            this._workspace.getReadAccess();
            if (this._state != IDLE) {
                throw new IllegalActionException((Nameable)this, "The model is already running.");
            }
            if (this._container == null) {
                throw new IllegalActionException((Nameable)this, "No model to run!");
            }
            this._setState(PREINITIALIZING);
            this._exitAfterWrapup = false;
            this._pauseRequested = false;
            this._typesResolved = false;
            this._iterationCount = 0;
            this._resumeNotifyWaiting = false;
            if (this._nameToAnalysis != null) {
                this._nameToAnalysis.clear();
                this._nameToAnalysis = null;
            }
            this._container.preinitialize();
            this.executeChangeRequests();
            this.resolveTypes();
            this._typesResolved = true;
        }
        finally {
            if (this._nameToAnalysis != null) {
                this._nameToAnalysis.clear();
                this._nameToAnalysis = null;
            }
            this._workspace.doneReading();
        }
    }

    public void removeExecutionListener(ExecutionListener listener) {
        if (listener == null || this._executionListeners == null) {
            return;
        }
        ListIterator listeners = this._executionListeners.listIterator();
        while (listeners.hasNext()) {
            WeakReference reference = (WeakReference)listeners.next();
            if (reference.get() != listener) continue;
            this._executionListeners.remove(listener);
        }
    }

    public void requestInitialization(Actor actor) {
        if (this._actorsToInitialize.contains(actor)) {
            return;
        }
        NamedObj container = actor.getContainer();
        while (container != null) {
            if (this._actorsToInitialize.contains(container)) {
                return;
            }
            container = container.getContainer();
        }
        LinkedList list = new LinkedList(this._actorsToInitialize);
        for (NamedObj otherActor : list) {
            NamedObj otherActorContainer = otherActor.getContainer();
            while (otherActorContainer != null) {
                if (otherActorContainer == actor) {
                    this._actorsToInitialize.remove(otherActor);
                    otherActorContainer = null;
                    continue;
                }
                otherActorContainer = otherActorContainer.getContainer();
            }
        }
        this._actorsToInitialize.add(actor);
    }

    public void resolveTypes() throws TypeConflictException {
        if (!(this._container instanceof TypedCompositeActor)) {
            return;
        }
        try {
            this._workspace.getReadAccess();
            this._setState(RESOLVING_TYPES);
            TypedCompositeActor.resolveTypes((TypedCompositeActor)this._container);
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (this._state == PAUSED) {
            Manager manager = this;
            synchronized (manager) {
                if (this._state != PAUSED) {
                    throw new InternalErrorException("resume() should be the only method that goes from PAUSED to not paused");
                }
                this._pauseRequested = false;
                this.notifyAll();
            }
        }
        if (this._state == PAUSED_ON_BREAKPOINT) {
            Manager manager = this;
            synchronized (manager) {
                if (this._state == PAUSED_ON_BREAKPOINT && this._resumeNotifyWaiting) {
                    this._resumeNotifyWaiting = false;
                    this.notifyAll();
                }
            }
        }
    }

    public void run() {
        try {
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                this.notifyListenersOfThrowable(throwable);
                this._thread = null;
            }
        }
        finally {
            this._thread = null;
        }
    }

    public static String shortDescription(Throwable throwable) {
        return MessageHandler.shortDescription(throwable);
    }

    public void startRun() throws IllegalActionException {
        if (this._state != IDLE) {
            throw new IllegalActionException((Nameable)this, "Model is " + this._state.getDescription());
        }
        this._finishRequested = false;
        this._thread = new PtolemyThread((Runnable)this, this._container.getName()){

            public void run() {
                Manager.this.run();
            }
        };
        this._thread.setPriority(1);
        this._thread.start();
    }

    public void stop() {
        this.finish();
    }

    public void terminate() {
        if (this._thread != null) {
            this._thread.stop();
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this._thread = null;
        }
        this._container.terminate();
        this._setState(CORRUPTED);
    }

    public static String timeAndMemory(long startTime) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L;
        return Manager.timeAndMemory(startTime, totalMemory, freeMemory);
    }

    public static String timeAndMemory(long startTime, long totalMemory, long freeMemory) {
        return String.valueOf(System.currentTimeMillis() - startTime) + " ms. Memory: " + totalMemory + "K Free: " + freeMemory + "K (" + Math.round((double)freeMemory / (double)totalMemory * 100.0) + "%)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        if (this._thread != null) {
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            Manager manager = this;
            synchronized (manager) {
                while (this.getState() != IDLE && this.getState() != CORRUPTED) {
                    try {
                        this.workspace().wait(this);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapup() throws KernelException, IllegalActionException {
        Manager manager = this;
        synchronized (manager) {
            if (this._state == IDLE || this._state == WRAPPING_UP) {
                throw new IllegalActionException((Nameable)this, "Cannot wrap up. The current state is: " + this._state.getDescription());
            }
            if (this._container == null) {
                throw new IllegalActionException((Nameable)this, "No model to run!");
            }
            this._setState(WRAPPING_UP);
        }
        this._container.wrapup();
        this.setDeferringChangeRequests(false);
        if (this._exitAfterWrapup) {
            StringUtilities.exit(0);
        }
        this._setState(IDLE);
    }

    protected void _makeManagerOf(CompositeActor compositeActor) {
        if (compositeActor != null) {
            this._workspace.remove(this);
        }
        this._container = compositeActor;
    }

    protected synchronized void _notifyListenersOfCompletion() {
        if (this._debugging) {
            this._debug("-- Manager completed execution with " + this._iterationCount + " iterations");
        }
        if (this._executionListeners != null) {
            ListIterator listeners = this._executionListeners.listIterator();
            while (listeners.hasNext()) {
                WeakReference reference = (WeakReference)listeners.next();
                ExecutionListener listener = (ExecutionListener)reference.get();
                if (listener != null) {
                    listener.executionFinished(this);
                    continue;
                }
                listeners.remove();
            }
        }
    }

    protected void _notifyListenersOfStateChange() {
        if (this._debugging) {
            this._debug("-- Manager state is now: " + this._state.getDescription());
        }
        if (this._executionListeners != null) {
            ListIterator listeners = this._executionListeners.listIterator();
            while (listeners.hasNext()) {
                WeakReference reference = (WeakReference)listeners.next();
                ExecutionListener listener = (ExecutionListener)reference.get();
                if (listener != null) {
                    listener.managerStateChanged(this);
                    continue;
                }
                listeners.remove();
            }
        }
    }

    protected synchronized void _setState(State newState) {
        if (this._state != newState) {
            this._state = newState;
            this._notifyListenersOfStateChange();
            this.notifyAll();
        }
    }

    public static class State {
        private String _description;

        private State(String description) {
            this._description = description;
        }

        public String getDescription() {
            return this._description;
        }

        private void setDescription(String description) {
            this._description = description;
        }

        public String toString() {
            return "The model is " + this.getDescription();
        }
    }
}

