/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;

public class Mailbox
extends AbstractReceiver {
    protected Token _token = null;

    public Mailbox() {
    }

    public Mailbox(IOPort container) throws IllegalActionException {
        super(container);
    }

    public void clear() throws IllegalActionException {
        this._token = null;
    }

    public Token get() throws NoTokenException {
        if (this._token == null) {
            throw new NoTokenException(this.getContainer(), "Attempt to get data from an empty mailbox.");
        }
        Token token = this._token;
        this._token = null;
        return token;
    }

    public boolean hasRoom() {
        return this._token == null;
    }

    public boolean hasRoom(int numberOfTokens) throws IllegalArgumentException {
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("hasRoom() requires a positive argument.");
        }
        if (numberOfTokens == 1) {
            return this._token == null;
        }
        return false;
    }

    public boolean hasToken() {
        return this._token != null;
    }

    public boolean hasToken(int numberOfTokens) throws IllegalArgumentException {
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("hasToken() requires a positive argument.");
        }
        if (numberOfTokens == 1) {
            return this._token != null;
        }
        return false;
    }

    public void put(Token token) throws NoRoomException {
        if (this._token != null) {
            throw new NoRoomException(this.getContainer(), "Cannot put a token in a full mailbox.");
        }
        this._token = token;
    }
}

