/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class IORelation
extends ComponentRelation {
    public Parameter width;
    public static final int CONFIGURATION = 512;
    private transient int _inferredWidth;
    private transient long _inferredWidthVersion = -1L;
    private boolean _suppressWidthPropagation = false;
    private int _width = 1;

    public IORelation() {
        this._init();
    }

    public IORelation(Workspace workspace) {
        super(workspace);
        this._init();
    }

    public IORelation(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        IntToken t;
        if (attribute instanceof Parameter && "width".equals(attribute.getName()) && (t = (IntToken)((Parameter)attribute).getToken()) != null) {
            int width = t.intValue();
            this._setWidth(width);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        IORelation newObject = (IORelation)super.clone(workspace);
        newObject._inferredWidthVersion = -1L;
        return newObject;
    }

    public Receiver[][] deepReceivers(IOPort except) {
        try {
            this._workspace.getReadAccess();
            Receiver[][] result = new Receiver[0][0];
            Iterator inputs = this.linkedDestinationPortList(except).iterator();
            HashMap<IOPort, Integer> seen = new HashMap<IOPort, Integer>();
            while (inputs.hasNext()) {
                Receiver[][] receivers;
                IOPort p = (IOPort)inputs.next();
                if (p.isInsideGroupLinked(this) && !p.isOpaque()) {
                    try {
                        receivers = p.getRemoteReceivers(this);
                    }
                    catch (IllegalActionException ex) {
                        throw new InternalErrorException(this, (Throwable)ex, null);
                    }
                }
                try {
                    int occurrence = 0;
                    if (seen.containsKey(p)) {
                        occurrence = (Integer)seen.get(p);
                        ++occurrence;
                    }
                    seen.put(p, occurrence);
                    receivers = p._getReceiversLinkedToGroup(this, occurrence);
                }
                catch (IllegalActionException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
                result = this._cascade(result, receivers);
            }
            Receiver[][] receiverArray = result;
            return receiverArray;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public int getWidth() {
        if (this._width == 0) {
            return this._inferWidth();
        }
        return this._width;
    }

    public boolean isWidthFixed() {
        return this._width != 0;
    }

    public List linkedDestinationPortList() {
        return this.linkedDestinationPortList(null);
    }

    public List linkedDestinationPortList(IOPort except) {
        try {
            this._workspace.getReadAccess();
            LinkedList<IOPort> resultPorts = new LinkedList<IOPort>();
            for (IOPort p : this.linkedPortList()) {
                if (p == except) continue;
                if (p.isInsideGroupLinked(this)) {
                    if (!p.isOutput()) continue;
                    resultPorts.addLast(p);
                    continue;
                }
                if (!p.isInput()) continue;
                resultPorts.addLast(p);
            }
            LinkedList<IOPort> linkedList = resultPorts;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration linkedDestinationPorts() {
        return this.linkedDestinationPorts(null);
    }

    public Enumeration linkedDestinationPorts(IOPort except) {
        return Collections.enumeration(this.linkedDestinationPortList(except));
    }

    public List linkedSourcePortList() {
        return this.linkedSourcePortList(null);
    }

    public List linkedSourcePortList(IOPort except) {
        try {
            this._workspace.getReadAccess();
            LinkedList<IOPort> resultPorts = new LinkedList<IOPort>();
            for (IOPort p : this.linkedPortList()) {
                if (p == except) continue;
                if (p.isInsideGroupLinked(this)) {
                    if (!p.isInput()) continue;
                    resultPorts.addLast(p);
                    continue;
                }
                if (!p.isOutput()) continue;
                resultPorts.addLast(p);
            }
            LinkedList<IOPort> linkedList = resultPorts;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration linkedSourcePorts() {
        return Collections.enumeration(this.linkedSourcePortList());
    }

    public Enumeration linkedSourcePorts(IOPort except) {
        return Collections.enumeration(this.linkedSourcePortList(except));
    }

    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        Director director;
        if (!(container instanceof CompositeActor) && container != null) {
            throw new IllegalActionException((Nameable)this, container, "IORelation can only be contained by CompositeActor.");
        }
        NamedObj oldContainer = this.getContainer();
        if (oldContainer instanceof CompositeActor && (director = ((CompositeActor)oldContainer).getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        if (container instanceof CompositeActor && (director = ((CompositeActor)container).getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        super.setContainer(container);
    }

    public void setWidth(int widthValue) throws IllegalActionException {
        this.width.setToken(new IntToken(widthValue));
    }

    protected void _checkPort(Port port) throws IllegalActionException {
        if (!(port instanceof IOPort)) {
            throw new IllegalActionException((Nameable)this, port, "IORelation can only link to a IOPort.");
        }
    }

    protected void _checkRelation(Relation relation, boolean symmetric) throws IllegalActionException {
        if (!(relation instanceof IORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "IORelation can only link to an IORelation.");
        }
        if (((IORelation)relation)._width != this._width) {
            throw new IllegalActionException((Nameable)this, relation, "Relations have different widths: " + this._width + " != " + ((IORelation)relation)._width);
        }
        super._checkRelation(relation, symmetric);
    }

    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            String result = bracket == 1 || bracket == 2 ? super._description(detail, indent, 1) : super._description(detail, indent, 0);
            if ((detail & 0x200) != 0) {
                if (result.trim().length() > 0) {
                    result = String.valueOf(result) + " ";
                }
                result = String.valueOf(result) + "configuration {";
                result = String.valueOf(result) + "width " + this.getWidth();
                if (this.isWidthFixed()) {
                    result = String.valueOf(result) + " fixed";
                }
                result = String.valueOf(result) + "}";
            }
            if (bracket == 2) {
                result = String.valueOf(result) + "}";
            }
            String string = result;
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    private Receiver[][] _cascade(Receiver[][] array1, Receiver[][] array2) throws InvalidStateException {
        if (array1 == null || array1.length <= 0) {
            return array2;
        }
        if (array2 == null || array2.length <= 0) {
            return array1;
        }
        int width = this.getWidth();
        Receiver[][] result = new Receiver[width][0];
        int i = 0;
        while (i < width) {
            if (array1[i] == null) {
                result[i] = array2[i];
            } else if (array1[i].length <= 0) {
                result[i] = array2[i];
            } else if (array2[i] == null) {
                result[i] = array1[i];
            } else if (array2[i].length <= 0) {
                result[i] = array1[i];
            } else {
                int m1 = array1[i].length;
                int m2 = array2[i].length;
                result[i] = new Receiver[m1 + m2];
                int j = 0;
                while (j < m1) {
                    result[i][j] = array1[i][j];
                    ++j;
                }
                j = m1;
                while (j < m1 + m2) {
                    result[i][j] = array2[i][j - m1];
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private int _inferWidth() {
        long version = this._workspace.getVersion();
        if (version != this._inferredWidthVersion) {
            this._inferredWidth = 1;
            for (IOPort p : this.linkedPortList()) {
                int portInsideWidth = 0;
                int portOutsideWidth = 0;
                int difference = 0;
                if (p.isInsideGroupLinked(this)) {
                    portInsideWidth = p._getInsideWidth(this);
                    portOutsideWidth = p._getOutsideWidth(null);
                    difference = portOutsideWidth - portInsideWidth;
                } else if (p.isLinked(this)) {
                    portInsideWidth = p._getInsideWidth(null);
                    portOutsideWidth = p._getOutsideWidth(this);
                    difference = portInsideWidth - portOutsideWidth;
                }
                if (difference <= this._inferredWidth) continue;
                this._inferredWidth = difference;
            }
            this._inferredWidthVersion = version;
        }
        return this._inferredWidth;
    }

    private void _init() {
        try {
            this.width = new Parameter(this, "width");
            this.width.setExpression("1");
            this.width.setTypeEquals(BaseType.INT);
        }
        catch (KernelException ex) {
            throw new InternalErrorException(ex);
        }
    }

    private void _setWidth(int width) throws IllegalActionException {
        if (width == this._width) {
            return;
        }
        try {
            Director director;
            this._workspace.getWriteAccess();
            if (width <= 0) {
                try {
                    this._inferWidth();
                }
                catch (InvalidStateException invalidStateException) {
                    throw new IllegalActionException((Nameable)this, "Cannot use unspecified width on this relation because of its links.");
                }
            }
            this._width = width;
            Iterator relations = this.relationGroupList().iterator();
            while (!this._suppressWidthPropagation && relations.hasNext()) {
                IORelation relation = (IORelation)relations.next();
                if (relation == this) continue;
                try {
                    relation._suppressWidthPropagation = true;
                    relation.width.setToken(new IntToken(width));
                }
                finally {
                    relation._suppressWidthPropagation = false;
                }
            }
            for (IOPort p : this.linkedPortList()) {
                Entity portContainer = (Entity)p.getContainer();
                if (portContainer == null) continue;
                portContainer.connectionsChanged(p);
            }
            NamedObj container = this.getContainer();
            if (container instanceof CompositeActor && (director = ((CompositeActor)container).getDirector()) != null) {
                director.invalidateSchedule();
                director.invalidateResolvedTypes();
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }
}

