/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.Director;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.kernel.SDFDirector;
import ptolemy.domains.sdf.lib.SDFConverter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class MatrixToDouble
extends SDFConverter {
    public Parameter columns;
    public Parameter rows = new Parameter((NamedObj)this, "rows");
    private int _rows;
    private int _columns;

    public MatrixToDouble(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.rows.setExpression("2");
        this.rows.setTypeEquals((Type)BaseType.INT);
        this.columns = new Parameter((NamedObj)this, "columns");
        this.columns.setExpression("2");
        this.columns.setTypeEquals((Type)BaseType.INT);
        this.output.setTypeEquals((Type)BaseType.DOUBLE);
        this.input.setTypeEquals((Type)BaseType.DOUBLE_MATRIX);
        this.output_tokenProductionRate.setExpression("rows * columns");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.rows || attribute == this.columns) {
            this._rows = ((IntToken)this.rows.getToken()).intValue();
            this._columns = ((IntToken)this.columns.getToken()).intValue();
            if (this._rows <= 0 || this._columns <= 0) {
                throw new IllegalActionException((Nameable)this, "Number of rows and columns is required to be positive.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public final void fire() throws IllegalActionException {
        super.fire();
        DoubleMatrixToken matrix = (DoubleMatrixToken)this.input.get(0);
        int inputRows = matrix.getRowCount();
        int inputColumns = matrix.getColumnCount();
        Director director = this.getDirector();
        if (director instanceof SDFDirector && inputRows * inputColumns != this._rows * this._columns) {
            throw new IllegalActionException((Nameable)this, "Received a matrix whose dimension does not match the declared dimensions.");
        }
        int totalSize = inputRows * inputColumns;
        DoubleToken[] result = new DoubleToken[totalSize];
        int k = 0;
        int i = 0;
        while (i < inputRows) {
            int j = 0;
            while (j < inputColumns) {
                result[k++] = (DoubleToken)matrix.getElementAsToken(i, j);
                ++j;
            }
            ++i;
        }
        this.output.send(0, (Token[])result, totalSize);
    }
}

