/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.domains.sdf.lib.FIR;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class LMSAdaptive
extends FIR {
    public TypedIOPort error;
    public Parameter errorDelay;
    public Parameter initialTaps;
    public Parameter stepSize;
    public TypedIOPort tapValues;

    public LMSAdaptive(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.interpolation.setVisibility(Settable.NONE);
        this.taps.setVisibility(Settable.NONE);
        this.error = new TypedIOPort((ComponentEntity)this, "error", true, false);
        this.tapValues = new TypedIOPort((ComponentEntity)this, "tapValues", false, true);
        this.stepSize = new Parameter((NamedObj)this, "stepSize");
        this.stepSize.setExpression("0.01");
        this.errorDelay = new Parameter((NamedObj)this, "errorDelay");
        this.errorDelay.setExpression("1");
        this.errorDelay.setTypeEquals((Type)BaseType.INT);
        this.initialTaps = new Parameter((NamedObj)this, "initialTaps");
        this.initialTaps.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.initialTaps.setExpression("{1.0, 0.0, 0.0, 0.0}");
        this.error.setTypeSameAs((Typeable)this.input);
        this.stepSize.setTypeSameAs((Typeable)this.input);
        this.tapValues.setTypeSameAs((Typeable)this.taps);
        this.taps.setTypeAtLeast((Typeable)this.initialTaps);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.initialTaps) {
            this.taps.setToken(this.initialTaps.getToken());
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LMSAdaptive newObject = (LMSAdaptive)((Object)super.clone(workspace));
        newObject.initialTaps.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newObject.error.setTypeSameAs((Typeable)newObject.input);
        newObject.tapValues.setTypeSameAs((Typeable)newObject.taps);
        newObject.stepSize.setTypeSameAs((Typeable)newObject.input);
        newObject.taps.setTypeAtLeast((Typeable)newObject.initialTaps);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        int errorDelayValue = ((IntToken)this.errorDelay.getToken()).intValue();
        int decimationValue = ((IntToken)this.decimation.getToken()).intValue();
        int decimationPhaseValue = ((IntToken)this.decimationPhase.getToken()).intValue();
        int index = errorDelayValue * decimationValue + decimationPhaseValue;
        Token factor = this.error.get(0).multiply(this.stepSize.getToken());
        int i = 0;
        while (i < this._taps.length) {
            Token datum = this._data[(this._mostRecent + index - 1) % this._data.length];
            this._taps[i] = this._taps[i].add(factor.multiply(datum));
            ++index;
            ++i;
        }
        this.tapValues.send(0, (Token)new ArrayToken(this._taps));
        super.fire();
    }

    public boolean prefire() throws IllegalActionException {
        if (this.error.hasToken(0)) {
            return super.prefire();
        }
        if (this._debugging) {
            this._debug("Called prefire(), which returns false.");
        }
        return false;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this.taps.setToken(this.initialTaps.getToken());
    }
}

