/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Chop
extends SDFTransformer {
    public Parameter numberToRead = new Parameter((NamedObj)this, "numberToRead");
    public Parameter numberToWrite;
    public Parameter offset;
    public Parameter usePastInputs;
    private int _highLimit;
    private int _inputIndex;
    private int _lowLimit;
    private int _numberToRead;
    private int _numberToWrite;
    private int _offsetValue;
    private Token[] _buffer;
    private Token[] _pastBuffer;
    private boolean _usePast;
    private boolean _pastNeedsInitializing;

    public Chop(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.numberToRead.setExpression("128");
        this.numberToRead.setTypeEquals((Type)BaseType.INT);
        this.numberToWrite = new Parameter((NamedObj)this, "numberToWrite");
        this.numberToWrite.setExpression("64");
        this.numberToWrite.setTypeEquals((Type)BaseType.INT);
        this.offset = new Parameter((NamedObj)this, "offset");
        this.offset.setExpression("0");
        this.offset.setTypeEquals((Type)BaseType.INT);
        this.usePastInputs = new Parameter((NamedObj)this, "usePastInputs");
        this.usePastInputs.setExpression("true");
        this.usePastInputs.setTypeEquals((Type)BaseType.BOOLEAN);
        this.input_tokenConsumptionRate.setExpression("numberToRead");
        this.output_tokenProductionRate.setExpression("numberToWrite");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numberToRead) {
            this._numberToRead = ((IntToken)this.numberToRead.getToken()).intValue();
            if (this._numberToRead <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid numberToRead: " + this._numberToRead);
            }
        } else if (attribute == this.numberToWrite) {
            this._numberToWrite = ((IntToken)this.numberToWrite.getToken()).intValue();
            if (this._numberToWrite <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid numberToWrite: " + this._numberToRead);
            }
            this._buffer = new Token[this._numberToWrite];
        } else if (attribute == this.offset) {
            this._offsetValue = ((IntToken)this.offset.getToken()).intValue();
        } else if (attribute == this.usePastInputs) {
            this._usePast = ((BooleanToken)this.usePastInputs.getToken()).booleanValue();
        }
        if ((attribute == this.offset || attribute == this.usePastInputs) && this._offsetValue > 0) {
            this._pastBuffer = new Token[this._offsetValue];
            this._pastNeedsInitializing = true;
        }
        if (attribute == this.numberToRead || attribute == this.numberToWrite || attribute == this.offset || attribute == this.usePastInputs) {
            this._highLimit = this._offsetValue + this._numberToRead - 1;
            if (this._highLimit >= this._numberToWrite) {
                this._highLimit = this._numberToWrite - 1;
            }
            if (this._offsetValue >= 0) {
                this._lowLimit = this._offsetValue;
                this._inputIndex = 0;
            } else {
                this._lowLimit = 0;
                this._inputIndex = -this._offsetValue;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int inputIndex = this._inputIndex;
        int pastBufferIndex = 0;
        Token[] inBuffer = this.input.get(0, this._numberToRead);
        Token zero = inBuffer[0].zero();
        int i = 0;
        while (i < this._numberToWrite) {
            if (i > this._highLimit) {
                this._buffer[i] = zero;
            } else if (i < this._lowLimit) {
                if (this._usePast) {
                    if (this._pastNeedsInitializing) {
                        int j = 0;
                        while (j < this._pastBuffer.length) {
                            this._pastBuffer[j] = zero;
                            ++j;
                        }
                        this._pastNeedsInitializing = false;
                    }
                    this._buffer[i] = this._pastBuffer[pastBufferIndex++];
                } else {
                    this._buffer[i] = zero;
                }
            } else {
                this._buffer[i] = inBuffer[inputIndex];
                ++inputIndex;
            }
            ++i;
        }
        if (this._usePast && this._offsetValue > 0) {
            int startCopy = this._numberToRead - this._offsetValue;
            int length = this._pastBuffer.length;
            int destination = 0;
            if (startCopy < 0) {
                destination = this._pastBuffer.length - this._numberToRead;
                System.arraycopy(this._pastBuffer, this._numberToRead, this._pastBuffer, 0, destination);
                startCopy = 0;
                length = this._numberToRead;
            }
            System.arraycopy(inBuffer, startCopy, this._pastBuffer, destination, length);
        }
        this.output.send(0, this._buffer, this._numberToWrite);
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._pastNeedsInitializing = true;
    }
}

