/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFConverter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class BitsToInt
extends SDFConverter {
    public Parameter numberOfBits = new Parameter((NamedObj)this, "numberOfBits");

    public BitsToInt(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.numberOfBits.setExpression("32");
        this.input_tokenConsumptionRate.setExpression("numberOfBits");
        this.input.setTypeEquals((Type)BaseType.BOOLEAN);
        this.output.setTypeEquals((Type)BaseType.INT);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numberOfBits) {
            int rate = ((IntToken)this.numberOfBits.getToken()).intValue();
            if (rate < 1 || rate > 32) {
                throw new IllegalActionException((Nameable)this, "Invalid number of bits: " + rate);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public final void fire() throws IllegalActionException {
        super.fire();
        int rate = ((IntToken)this.numberOfBits.getToken()).intValue();
        Token[] bits = this.input.get(0, rate);
        int integer = 0;
        int i = 1;
        while (i < rate) {
            integer <<= 1;
            if (((BooleanToken)bits[i]).booleanValue()) {
                ++integer;
            }
            ++i;
        }
        if (((BooleanToken)bits[0]).booleanValue()) {
            integer -= 1 << rate - 1;
        }
        IntToken value = new IntToken(integer);
        this.output.send(0, (Token)value);
    }
}

