/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.data.Token;
import ptolemy.domains.sdf.kernel.ArrayFIFOQueue;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public class SDFReceiver
extends AbstractReceiver {
    public static final int INFINITE_CAPACITY = -1;
    public int _waitingTokens = 0;
    private ArrayFIFOQueue _queue;
    private Token[] _tokenArray;

    public SDFReceiver() {
        this._queue = new ArrayFIFOQueue();
    }

    public SDFReceiver(int size) {
        this._queue = new ArrayFIFOQueue(size);
    }

    public SDFReceiver(IOPort container) throws IllegalActionException {
        super(container);
        this._queue = new ArrayFIFOQueue();
    }

    public SDFReceiver(IOPort container, int size) throws IllegalActionException {
        super(container);
        this._queue = new ArrayFIFOQueue(size);
    }

    public void clear() {
        this._queue.clear();
        this._waitingTokens = 0;
    }

    public Token get() {
        if (this._queue.isEmpty()) {
            throw new NoTokenException((Nameable)this.getContainer(), "Attempt to get token from an empty QueueReceiver.");
        }
        return (Token)this._queue.take();
    }

    public Token get(int offset) {
        try {
            return (Token)this._queue.get(offset);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoTokenException((Nameable)this.getContainer(), "Offset " + offset + " out of range with " + this._queue.size() + " tokens in the receiver and " + this._queue.historySize() + " in history.");
        }
    }

    public Token[] getArray(int count) {
        if (this._tokenArray == null || count != this._tokenArray.length) {
            this._tokenArray = new Token[count];
        }
        this._queue.takeArray(this._tokenArray, count);
        return this._tokenArray;
    }

    public int getCapacity() {
        return this._queue.getCapacity();
    }

    public int getHistoryCapacity() {
        return this._queue.getHistoryCapacity();
    }

    public boolean hasRoom() {
        return !this._queue.isFull();
    }

    public boolean hasRoom(int tokens) throws IllegalArgumentException {
        if (tokens < 1) {
            throw new IllegalArgumentException("The argument must not be negative. It was: " + tokens);
        }
        if (this._queue.getCapacity() == -1) {
            return true;
        }
        return this._queue.size() + tokens <= this._queue.getCapacity();
    }

    public boolean hasToken() {
        return !this._queue.isEmpty();
    }

    public boolean hasToken(int tokens) throws IllegalArgumentException {
        if (tokens < 0) {
            throw new IllegalArgumentException("The argument must not be negative. It was: " + tokens);
        }
        return this._queue.size() >= tokens;
    }

    public Enumeration historyElements() {
        return this._queue.historyElements();
    }

    public int historySize() {
        return this._queue.historySize();
    }

    public void put(Token token) {
        if (!this._queue.put(token)) {
            throw new NoRoomException((Nameable)this.getContainer(), "Queue is at capacity of " + this._queue.getCapacity() + ". Cannot put a token.");
        }
    }

    public void setCapacity(int capacity) throws IllegalActionException {
        try {
            this._queue.setCapacity(capacity);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException((Nameable)this.getContainer(), (Throwable)ex, "Failed to set capacity to " + capacity);
        }
    }

    public void setHistoryCapacity(int capacity) throws IllegalActionException {
        try {
            this._queue.setHistoryCapacity(capacity);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException((Nameable)this.getContainer(), (Throwable)ex, "Failed to set history capacity to " + capacity);
        }
    }

    public int size() {
        return this._queue.size();
    }
}

