/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;

public final class ArrayFIFOQueue
implements Cloneable {
    public static final int INFINITE_CAPACITY = -1;
    public static final int DEFAULT_CAPACITY = -1;
    public static final int STARTING_ARRAYSIZE = 4;
    public static final int DEFAULT_HISTORY_CAPACITY = 0;
    private Nameable _container = null;
    private int _queueMaxCapacity = -1;
    private Object[] _queueArray;
    private int _queueFront = 0;
    private int _queueBack = 0;
    private int _queueSize = 0;
    private int _historyCapacity = 0;
    private LinkedList _historyList = null;

    public ArrayFIFOQueue() {
        this._queueArray = new Object[4];
        this._queueMaxCapacity = -1;
        this._historyList = new LinkedList();
    }

    public ArrayFIFOQueue(int size) {
        this._queueArray = new Object[size];
        this._queueMaxCapacity = size;
        this._historyList = new LinkedList();
    }

    public ArrayFIFOQueue(Nameable container) {
        this();
        this._container = container;
    }

    public ArrayFIFOQueue(Nameable container, int size) {
        this(size);
        this._container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayFIFOQueue(ArrayFIFOQueue model) {
        this();
        ArrayFIFOQueue arrayFIFOQueue = model;
        synchronized (arrayFIFOQueue) {
            this._queueSize = model._queueSize;
            this._queueArray = new Object[model._queueArray.length];
            this._queueFront = model._queueFront;
            this._queueBack = model._queueBack;
            System.arraycopy(model._queueArray, 0, this._queueArray, 0, this._queueArray.length);
            this._historyList.addAll(model._historyList);
        }
    }

    public void clear() {
        this._queueFront = 0;
        this._queueBack = 0;
        this._queueSize = 0;
    }

    public Object clone() {
        return new ArrayFIFOQueue(this);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.elementList());
    }

    public List elementList() {
        LinkedList<Object> l = new LinkedList<Object>();
        if (this._queueFront < this._queueBack || this.isFull()) {
            int i = this._queueBack;
            while (i < this._queueArray.length) {
                l.addLast(this._queueArray[i]);
                ++i;
            }
            i = 0;
            while (i < this._queueFront) {
                l.addLast(this._queueArray[i]);
                ++i;
            }
        } else {
            int i = this._queueBack;
            while (i < this._queueFront) {
                l.addLast(this._queueArray[i]);
                ++i;
            }
        }
        return l;
    }

    public Object get(int offset) throws NoSuchElementException {
        Object object = null;
        if (offset >= 0) {
            if (offset >= this.size()) {
                String message = ".";
                if (this._container != null) {
                    message = " contained by " + this._container.getFullName();
                }
                throw new NoSuchElementException("No object at offset " + offset + " in the FIFOQueue" + message);
            }
            int location = this._queueBack + offset;
            if (location >= this._queueArray.length) {
                location %= this._queueArray.length;
            }
            object = this._queueArray[location];
        } else {
            try {
                object = this._historyList.get(this.historySize() + offset);
            }
            catch (Exception exception) {
                String message = ".";
                if (this._container != null) {
                    message = " contained by " + this._container.getFullName();
                }
                throw new NoSuchElementException("No object at offset " + offset + " in the FIFOQueue" + message);
            }
        }
        return object;
    }

    public int getCapacity() {
        return this._queueMaxCapacity;
    }

    public Nameable getContainer() {
        return this._container;
    }

    public int getHistoryCapacity() {
        return this._historyCapacity;
    }

    public Enumeration historyElements() {
        return Collections.enumeration(this._historyList);
    }

    public int historySize() {
        return this._historyList.size();
    }

    public boolean isEmpty() {
        return this._queueSize == 0;
    }

    public boolean isFull() {
        return this._queueSize >= this._queueArray.length;
    }

    public boolean put(Object element) {
        if (this._queueArray.length - this._queueSize >= 1) {
            this._queueArray[this._queueFront] = element;
            ++this._queueFront;
            if (this._queueFront >= this._queueArray.length) {
                this._queueFront %= this._queueArray.length;
            }
            ++this._queueSize;
            return true;
        }
        if (this._queueMaxCapacity == -1) {
            this._resizeArray(this._queueArray.length * 2);
            return this.put(element);
        }
        return false;
    }

    public boolean putArray(Object[] element) {
        int count = element.length;
        return this.putArray(element, count);
    }

    public boolean putArray(Object[] element, int count) {
        if (this._queueArray.length - this._queueSize >= count) {
            if (count <= this._queueArray.length - this._queueFront) {
                System.arraycopy(element, 0, this._queueArray, this._queueFront, count);
                this._queueFront += count;
                if (this._queueFront >= this._queueArray.length) {
                    this._queueFront %= this._queueArray.length;
                }
                this._queueSize += count;
            } else {
                System.arraycopy(element, 0, this._queueArray, this._queueFront, this._queueArray.length - this._queueFront);
                System.arraycopy(element, this._queueArray.length - this._queueFront, this._queueArray, 0, count - (this._queueArray.length - this._queueFront));
                this._queueFront += count;
                if (this._queueFront >= this._queueArray.length) {
                    this._queueFront %= this._queueArray.length;
                }
                this._queueSize += count;
            }
            return true;
        }
        if (this._queueMaxCapacity == -1) {
            try {
                this._resizeArray(this._queueArray.length * 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.putArray(element, count);
        }
        return false;
    }

    public void setCapacity(int capacity) throws IllegalActionException {
        if (capacity == -1) {
            this._queueMaxCapacity = -1;
            return;
        }
        if (capacity < -1) {
            throw new IllegalActionException(this._container, "Queue Capacity cannot be negative");
        }
        if (this.size() > capacity) {
            throw new IllegalActionException(this._container, "Queue contains more elements than the proposed capacity.");
        }
        this._queueMaxCapacity = capacity;
        this._resizeArray(capacity);
    }

    public void setContainer(Nameable container) {
        this._container = container;
    }

    public void setHistoryCapacity(int capacity) throws IllegalActionException {
        if (capacity > 0) {
            while (this._historyList.size() > capacity) {
                this._historyList.removeFirst();
            }
        } else if (capacity == 0) {
            this._historyList.clear();
        } else if (capacity != -1) {
            throw new IllegalActionException(this._container, "Cannot set history capacity to " + capacity);
        }
        this._historyCapacity = capacity;
    }

    public int size() {
        return this._queueSize;
    }

    public Object take() {
        Object object = null;
        if (this.isEmpty()) {
            String message = "";
            if (this._container != null) {
                message = " contained by " + this._container.getFullName();
            }
            throw new NoSuchElementException("The FIFOQueue" + message + " is empty!");
        }
        object = this._queueArray[this._queueBack];
        this._queueArray[this._queueBack] = null;
        ++this._queueBack;
        if (this._queueBack >= this._queueArray.length) {
            this._queueBack %= this._queueArray.length;
        }
        --this._queueSize;
        if (this._historyCapacity != 0) {
            if (this._historyCapacity == this._historyList.size()) {
                this._historyList.removeFirst();
            }
            this._historyList.addLast(object);
        }
        return object;
    }

    public void takeArray(Object[] objects) throws NoSuchElementException {
        int count = objects.length;
        this.takeArray(objects, count);
    }

    public void takeArray(Object[] objects, int count) throws NoSuchElementException {
        if (this.size() < count) {
            String message = "";
            if (this._container != null) {
                message = " contained by " + this._container.getFullName();
            }
            throw new NoSuchElementException("The FIFOQueue" + message + " does not contain enough elements!");
        }
        if (count <= this._queueArray.length - this._queueBack) {
            System.arraycopy(this._queueArray, this._queueBack, objects, 0, count);
        } else {
            System.arraycopy(this._queueArray, this._queueBack, objects, 0, this._queueArray.length - this._queueBack);
            System.arraycopy(this._queueArray, 0, objects, this._queueArray.length - this._queueBack, count - (this._queueArray.length - this._queueBack));
        }
        this._queueBack += count;
        if (this._queueBack >= this._queueArray.length) {
            this._queueBack %= this._queueArray.length;
        }
        this._queueSize -= count;
        if (this._historyCapacity != 0) {
            if (this._historyCapacity == this._historyList.size()) {
                this._historyList.removeFirst();
            }
            this._historyList.addLast(objects);
        }
    }

    private void _resizeArray(int newSize) {
        if (newSize < 0) {
            throw new InternalErrorException("Buffer size of " + newSize + " is less than zero.");
        }
        if (this.size() > newSize) {
            throw new InternalErrorException("Queue contains more elements than the proposed array size.");
        }
        if (this._queueMaxCapacity != -1 && newSize > this._queueMaxCapacity) {
            throw new InternalErrorException("The proposed array size exceeds the maximum declared queue size.");
        }
        Object[] newArray = new Object[newSize];
        if (newSize == 0) {
            this._queueFront = 0;
        } else if (this._queueFront < this._queueBack || this.isFull()) {
            System.arraycopy(this._queueArray, this._queueBack, newArray, 0, this._queueArray.length - this._queueBack);
            System.arraycopy(this._queueArray, 0, newArray, this._queueArray.length - this._queueBack, this._queueFront);
            this._queueFront = this._queueArray.length - this._queueBack + this._queueFront;
            if (this._queueFront >= newArray.length) {
                this._queueFront %= newArray.length;
            }
        } else {
            System.arraycopy(this._queueArray, this._queueBack, newArray, 0, this._queueFront - this._queueBack);
            this._queueFront -= this._queueBack;
            if (this._queueFront >= newArray.length) {
                this._queueFront %= newArray.length;
            }
        }
        this._queueArray = newArray;
        this._queueBack = 0;
    }
}

