/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.pn.kernel.event;

import ptolemy.actor.Actor;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.InternalErrorException;

public class PNProcessEvent {
    public static final int BLOCKED_ON_DELAY = 111;
    public static final int BLOCKED_ON_MUTATION = 112;
    public static final int BLOCKED_ON_READ = 113;
    public static final int BLOCKED_ON_WRITE = 114;
    public static final int FINISHED_ABRUPTLY = 734;
    public static final int FINISHED_PROPERLY = 735;
    public static final int FINISHED_WITH_EXCEPTION = 736;
    public static final int PROCESS_BLOCKED = 367;
    public static final int PROCESS_FINISHED = 368;
    public static final int PROCESS_PAUSED = 369;
    public static final int PROCESS_RUNNING = 370;
    private Actor _actor = null;
    private int _cause = 0;
    private Exception _exception = null;
    private int _state = 0;

    public PNProcessEvent(Actor actor, int state) {
        this(actor, state, 0);
    }

    public PNProcessEvent(Actor actor, int state, int cause) {
        this._actor = actor;
        if (state < 367 || state > 370) {
            throw new InternalErrorException("state '" + state + "' is incorrect, it must be one of " + 367 + ", " + 368 + ", " + 369 + " or " + 370);
        }
        this._state = state;
        this._cause = cause;
    }

    public PNProcessEvent(Actor actor, Exception exception) {
        this._actor = actor;
        this._state = 368;
        this._cause = 736;
        this._exception = exception;
    }

    public Actor getActor() {
        return this._actor;
    }

    public int getBlockingCause() {
        return this._cause;
    }

    public int getCurrentState() {
        return this._state;
    }

    public Exception getException() {
        return this._exception;
    }

    public int getFinishingCause() {
        return this._cause;
    }

    public String toString() {
        String result;
        String state = null;
        String cause = null;
        if (this._state == 367) {
            state = "PROCESS_BLOCKED";
            cause = this._cause == 111 ? "BLOCKED_ON_DELAY" : (this._cause == 112 ? "BLOCKED_ON_MUTATION" : (this._cause == 113 ? "BLOCKED_ON_READ" : (this._cause == 114 ? "BLOCKED_ON_WRITE" : "BLOCKING_CAUSE_UNKNOWN")));
            result = "State of " + ((Entity)this._actor).getFullName() + " is " + state + " and the cause = " + cause;
        } else if (this._state == 368) {
            state = "PROCESS_FINISHED";
            cause = this._cause == 734 ? "FINISHED_ABRUPTLY" : (this._cause == 735 ? "FINISHED_PROPERLY" : (this._cause == 736 ? "FINISHED_WITH_EXCEPTION with " + (this._exception == null ? "null exception" : "exception " + this._exception) : "FINISHED_CAUSE_UNKNOWN"));
            result = "State of " + ((Entity)this._actor).getFullName() + " is " + state + " and the cause = " + cause;
        } else if (this._state == 369) {
            state = "PROCESS_PAUSED";
            result = "State of " + ((Entity)this._actor).getFullName() + " is " + state;
        } else if (this._state == 370) {
            state = "PROCESS_RUNNING";
            result = "State of " + ((Entity)this._actor).getFullName() + " is " + state;
        } else {
            state = "UNKNOWN_PROCESS_STATE";
            result = "State of " + ((Entity)this._actor).getFullName() + " is " + state;
        }
        return result;
    }
}

