/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.modal;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.ct.kernel.CTCompositeActor;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.FSMDirector;
import ptolemy.domains.fsm.modal.FunctionDependencyOfModalModel;
import ptolemy.domains.fsm.modal.ModalController;
import ptolemy.domains.fsm.modal.ModalPort;
import ptolemy.domains.fsm.modal.Refinement;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.MessageHandler;

public class ModalModel
extends CTCompositeActor
implements ChangeListener {
    public StringParameter directorClass;
    public Parameter conservativeAnalysis;
    protected FSMActor _controller;
    private FunctionDependencyOfModalModel _functionDependency;

    public ModalModel(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public ModalModel(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.directorClass) {
            Director director = this.getDirector();
            String className = this.directorClass.stringValue();
            if (director == null || !director.getClass().getName().equals(className)) {
                try {
                    Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalActionException((Nameable)this, null, (Throwable)e, "Invalid directorClass.");
                }
                ChangeRequest request = new ChangeRequest(this, "Create a new director"){

                    protected void _execute() throws Exception {
                        boolean supportMultirateFiring;
                        Director executiveDirector;
                        Director director = ModalModel.this.getDirector();
                        Class<?> newDirectorClass = Class.forName(ModalModel.this.directorClass.stringValue());
                        Constructor<?> newDirectorConstructor = newDirectorClass.getConstructor(CompositeEntity.class, String.class);
                        FSMDirector newDirector = (FSMDirector)((Object)newDirectorConstructor.newInstance(ModalModel.this, ModalModel.this.uniqueName("_Director")));
                        newDirector.setPersistent(false);
                        newDirector.controllerName.setExpression("_Controller");
                        if (director != null && director.getContainer() == ModalModel.this) {
                            director.setContainer(null);
                        }
                        if ((executiveDirector = ModalModel.this.getExecutiveDirector()) != null && (supportMultirateFiring = executiveDirector.supportMultirateFiring())) {
                            ModalModel.this.getController().setSupportMultirate(true);
                        }
                    }
                };
                this.requestChange(request);
            }
        } else if (attribute == this.conservativeAnalysis) {
            this._functionDependency = null;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void changeExecuted(ChangeRequest change) {
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        MessageHandler.error((String)"Failed to create a new director.", (Throwable)exception);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ModalModel newModel = (ModalModel)super.clone(workspace);
        newModel._controller = (FSMActor)newModel.getEntity("_Controller");
        try {
            newModel.directorClass.validate();
            newModel.executeChangeRequests();
        }
        catch (IllegalActionException illegalActionException) {
            throw new CloneNotSupportedException("Failed to validate the director of the clone of " + this.getFullName());
        }
        return newModel;
    }

    public boolean containsDynamicActors() {
        boolean result = false;
        Iterator actors = this.deepEntityList().iterator();
        while (!result && actors.hasNext()) {
            Actor actor = (Actor)actors.next();
            if (actor instanceof FSMActor) continue;
            result |= ((CTCompositeActor)actor).containsDynamicActors();
        }
        return result;
    }

    public boolean containsWaveformGenerators() {
        boolean result = false;
        Iterator actors = this.deepEntityList().iterator();
        while (!result && actors.hasNext()) {
            Actor actor = (Actor)actors.next();
            if (actor instanceof FSMActor) continue;
            result |= ((CTCompositeActor)actor).containsWaveformGenerators();
        }
        return result;
    }

    public FunctionDependency getFunctionDependency() {
        if (this._functionDependency == null) {
            try {
                this._functionDependency = new FunctionDependencyOfModalModel((CompositeActor)this);
                boolean value = ((BooleanToken)this.conservativeAnalysis.getToken()).booleanValue();
                this._functionDependency.setConservativeAnalysis(value);
            }
            catch (NameDuplicationException nameDuplicationException) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
            catch (IllegalActionException illegalActionException) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
        }
        return this._functionDependency;
    }

    public FSMActor getController() {
        return this._controller;
    }

    public Port newPort(String name) throws NameDuplicationException {
        try {
            this._workspace.getWriteAccess();
            ModalPort port = new ModalPort((ComponentEntity)this, name);
            for (Entity entity : this.entityList()) {
                if (entity instanceof ModalController) {
                    if (entity.getPort(name) != null) continue;
                    try {
                        ((ModalController)entity)._mirrorDisable = true;
                        entity.newPort(name);
                        continue;
                    }
                    finally {
                        ((ModalController)entity)._mirrorDisable = false;
                    }
                }
                if (!(entity instanceof Refinement) || entity.getPort(name) != null) continue;
                try {
                    ((Refinement)entity)._mirrorDisable = true;
                    entity.newPort(name);
                }
                finally {
                    ((Refinement)entity)._mirrorDisable = false;
                }
            }
            ModalPort modalPort = port;
            return modalPort;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("ModalModel.newPort: Internal error: " + ex.getMessage());
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this.setClassName("ptolemy.domains.fsm.modal.ModalModel");
        this._controller = new ModalController((CompositeEntity)this, "_Controller");
        this.directorClass = new StringParameter((NamedObj)this, "directorClass");
        FSMDirector defaultFSMDirector = new FSMDirector((CompositeEntity)this, "_Director");
        defaultFSMDirector.controllerName.setExpression("_Controller");
        Director executiveDirector = this.getExecutiveDirector();
        if (executiveDirector != null) {
            String[] suggestions = executiveDirector.suggestedModalModelDirectors();
            int i = 0;
            while (i < suggestions.length) {
                this.directorClass.addChoice(suggestions[i]);
                if (i == 0) {
                    this.directorClass.setExpression(suggestions[i]);
                }
                ++i;
            }
        } else {
            this.directorClass.setExpression("ptolemy.domains.fsm.kernel.FSMDirector");
        }
        this.conservativeAnalysis = new Parameter((NamedObj)this, "conservativeAnalysis");
        this.conservativeAnalysis.setTypeEquals((Type)BaseType.BOOLEAN);
        this.conservativeAnalysis.setToken((Token)BooleanToken.TRUE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-28\" y=\"-18\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<ellipse cx=\"0\" cy=\"0\" rx=\"15\" ry=\"10\"/>\n<circle cx=\"-15\" cy=\"0\" r=\"5\" style=\"fill:white\"/>\n<circle cx=\"15\" cy=\"0\" r=\"5\" style=\"fill:white\"/>\n</svg>\n");
    }
}

