/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.actor.util.ConstVariableModelAnalysis;
import ptolemy.actor.util.DFUtilities;
import ptolemy.actor.util.DependencyDeclaration;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.domains.fsm.kernel.Action;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.FSMDirector;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.domains.sdf.kernel.SDFReceiver;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class MultirateFSMDirector
extends FSMDirector {
    protected boolean _reinitialize;
    protected boolean _refinementPostfire;

    public MultirateFSMDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void chooseNextNonTransientState(State currentState) throws IllegalActionException {
        State state = this.chooseTransition(currentState);
        TypedActor[] actors = state.getRefinement();
        while (actors == null) {
            super.postfire();
            state = this.chooseTransition(state);
            Transition transition = this._getLastChosenTransition();
            if (transition == null) {
                throw new IllegalActionException((Nameable)this, "Reached a state without a refinement: " + state.getName());
            }
            actors = transition.destinationState().getRefinement();
        }
    }

    public State chooseTransition(State state) throws IllegalActionException {
        State destinationState;
        Transition transition = null;
        if (state.getRefinement() != null && state.preemptiveTransitionList().size() != 0) {
            throw new IllegalActionException((Nameable)this, String.valueOf(state.getName()) + " cannot have outgoing preemptive " + "transitions because the state has a refinement.");
        }
        if (state.getRefinement() == null) {
            transition = this._chooseTransition(state.preemptiveTransitionList());
        }
        if (transition == null) {
            transition = this._chooseTransition(state.nonpreemptiveTransitionList());
        }
        if (transition == null) {
            destinationState = state;
        } else {
            destinationState = transition.destinationState();
            TypedActor[] actors = transition.getRefinement();
            if (actors != null) {
                throw new IllegalActionException((Nameable)this, "MultirateFSM Director does not support transition refinements.");
            }
            this._readOutputsFromRefinement();
            for (Action action : transition.choiceActionList()) {
                action.execute();
            }
        }
        return destinationState;
    }

    public void fire() throws IllegalActionException {
        FSMActor controller = this.getController();
        this._readInputs();
        State currentState = controller.currentState();
        TypedActor[] actors = currentState.getRefinement();
        if (actors == null || actors.length != 1) {
            throw new IllegalActionException((Nameable)this, "Current state is required to have exactly one refinement: " + currentState.getName());
        }
        if (!this._stopRequested && actors[0].prefire()) {
            if (this._debugging) {
                this._debug(this.getFullName(), " fire refinement", ((NamedObj)actors[0]).getName());
            }
            actors[0].fire();
            this._refinementPostfire = actors[0].postfire();
        }
        this._readOutputsFromRefinement();
        this.chooseNextNonTransientState(currentState);
    }

    public State getNonTransientState() throws IllegalActionException {
        FSMActor controller = this.getController();
        State currentState = controller.currentState();
        TypedActor[] currentRefinements = currentState.getRefinement();
        while (currentRefinements == null) {
            this.chooseTransition(currentState);
            super.postfire();
            currentState = controller.currentState();
            Transition lastChosenTransition = this._getLastChosenTransition();
            if (lastChosenTransition == null) {
                throw new IllegalActionException((Nameable)this, "Reached a transient state without an enabled transition.");
            }
            currentRefinements = currentState.getRefinement();
        }
        return currentState;
    }

    public void initialize() throws IllegalActionException {
        FSMActor controller = this.getController();
        State currentState = controller.currentState();
        State initialState = controller.getInitialState();
        if (!this._reinitialize) {
            super.initialize();
            this._reinitialize = true;
            if (initialState != currentState) {
                this._setCurrentState(currentState);
                this._setCurrentConnectionMap();
                this._currentLocalReceiverMap = (Map)this._localReceiverMaps.get((Object)currentState);
            }
        } else {
            super.initialize();
            currentState = this.getNonTransientState();
            TypedActor[] currentRefinements = currentState.getRefinement();
            if (currentRefinements == null || currentRefinements.length != 1) {
                throw new IllegalActionException((Nameable)this, "Multiple refinements are not supported. Found multiple refinements in: " + currentState.getName());
            }
            TypedCompositeActor currentRefinement = (TypedCompositeActor)currentRefinements[0];
            Director refinementDir = currentRefinement.getDirector();
            if (refinementDir instanceof MultirateFSMDirector) {
                refinementDir.initialize();
            }
            this._updateInputTokenConsumptionRates(currentRefinement);
            this._updateOutputTokenProductionRates(currentRefinement);
        }
    }

    public boolean makeStateTransition() throws IllegalActionException {
        FSMActor controller = this.getController();
        State currentState = controller.currentState();
        Transition lastChosenTransition = this._getLastChosenTransition();
        boolean superPostfire = super.postfire();
        currentState = controller.currentState();
        TypedActor[] actors = currentState.getRefinement();
        if (actors == null || actors.length != 1) {
            throw new IllegalActionException((Nameable)this, "Current state is required to have exactly one refinement: " + currentState.getName());
        }
        TypedCompositeActor actor = (TypedCompositeActor)actors[0];
        if (lastChosenTransition != null) {
            Director refinementDir = actor.getDirector();
            if (refinementDir instanceof MultirateFSMDirector) {
                refinementDir.postfire();
            } else if (refinementDir instanceof StaticSchedulingDirector) {
                refinementDir.invalidateSchedule();
                ((StaticSchedulingDirector)refinementDir).getScheduler().getSchedule();
            }
        }
        this._updateInputTokenConsumptionRates(actor);
        this._updateOutputTokenProductionRates(actor);
        return superPostfire;
    }

    public Receiver newReceiver() {
        return new SDFReceiver();
    }

    public boolean postfire() throws IllegalActionException {
        boolean controllerPostfire = this.makeStateTransition();
        return this._refinementPostfire && controllerPostfire;
    }

    public void preinitialize() throws IllegalActionException {
        this._reinitialize = false;
        this._getEnclosingDomainActor();
        FSMActor controller = this.getController();
        State initialState = controller.getInitialState();
        this._setCurrentState(initialState);
        State currentState = this.getNonTransientState();
        super.preinitialize();
        this._setCurrentState(currentState);
        TypedActor[] currentRefinements = currentState.getRefinement();
        if (currentRefinements == null || currentRefinements.length != 1) {
            throw new IllegalActionException((Nameable)this, "Current state is required to have exactly one refinement: " + controller.currentState().getName());
        }
        TypedCompositeActor currentRefinement = (TypedCompositeActor)currentRefinements[0];
        this._updateInputTokenConsumptionRates(currentRefinement);
        this._updateOutputTokenProductionRates(currentRefinement);
        ConstVariableModelAnalysis analysis = ConstVariableModelAnalysis.getAnalysis((NamedObj)this);
        CompositeActor model = (CompositeActor)this.getContainer();
        for (IOPort port : model.portList()) {
            if (port instanceof ParameterPort) continue;
            if (port.isInput()) {
                this._declareReconfigurationDependencyForRefinementRateVariables(analysis, port, "tokenConsumptionRate");
            }
            if (!port.isOutput()) continue;
            this._declareReconfigurationDependencyForRefinementRateVariables(analysis, port, "tokenProductionRate");
            this._declareReconfigurationDependencyForRefinementRateVariables(analysis, port, "tokenInitProduction");
        }
    }

    public boolean transferInputs(IOPort port) throws IllegalActionException {
        if (!port.isInput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, (Nameable)port, "transferInputs: port argument is not an opaqueinput port.");
        }
        boolean transferred = false;
        Receiver[][] insideReceivers = this._currentLocalReceivers(port);
        int rate = DFUtilities.getTokenConsumptionRate((IOPort)port);
        int i = 0;
        while (i < port.getWidth()) {
            try {
                if (insideReceivers != null && insideReceivers[i] != null) {
                    int j = 0;
                    while (j < insideReceivers[i].length) {
                        insideReceivers[i][j].clear();
                        ++j;
                    }
                    int k = 0;
                    while (k < rate) {
                        if (port.hasToken(i)) {
                            Token token = port.get(i);
                            port.sendInside(i, token);
                        }
                        ++k;
                    }
                    transferred = true;
                }
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException("Director.transferInputs: Internal error: " + (Object)((Object)ex));
            }
            ++i;
        }
        return transferred;
    }

    public boolean transferOutputs(IOPort port) throws IllegalActionException {
        if (!port.isOutput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, (Nameable)port, "MultirateFSMDirector: transferOutputs():  port argument is not an opaque output port.");
        }
        boolean transferred = false;
        int rate = DFUtilities.getRate((IOPort)port);
        Receiver[][] insideReceivers = port.getInsideReceivers();
        int i = 0;
        while (i < port.getWidth()) {
            if (insideReceivers != null && insideReceivers[i] != null) {
                int k = 0;
                while (k < rate) {
                    try {
                        Token token = port.getInside(i);
                        port.send(i, token);
                    }
                    catch (NoTokenException ex) {
                        throw new InternalErrorException("Director.transferOutputs: Not enough tokens for port " + port.getName() + " " + (Object)((Object)ex));
                    }
                    ++k;
                }
            }
            transferred = true;
            ++i;
        }
        return transferred;
    }

    protected void _declareDependency(ConstVariableModelAnalysis analysis, IOPort port, String name, List dependents) throws IllegalActionException {
        Variable variable = DFUtilities.getRateVariable((Port)port, (String)name);
        DependencyDeclaration declaration = (DependencyDeclaration)variable.getAttribute("_MultirateFSMRateDependencyDeclaration", DependencyDeclaration.class);
        if (declaration == null) {
            try {
                declaration = new DependencyDeclaration(variable, "_MultirateFSMRateDependencyDeclaration");
            }
            catch (NameDuplicationException nameDuplicationException) {}
        }
        declaration.setDependents(dependents);
        analysis.addDependencyDeclaration(declaration);
    }

    protected void _declareReconfigurationDependencyForRefinementRateVariables(ConstVariableModelAnalysis analysis, IOPort port, String parameterName) throws IllegalActionException {
        List refinementRateVariables = this._getRefinementRateVariables(port, parameterName);
        this._declareDependency(analysis, port, parameterName, refinementRateVariables);
        boolean isConstantAndIdentical = true;
        Token value = null;
        Iterator variables = refinementRateVariables.iterator();
        while (variables.hasNext() && isConstantAndIdentical) {
            Variable rateVariable = (Variable)variables.next();
            boolean bl = isConstantAndIdentical = isConstantAndIdentical && analysis.getChangeContext(rateVariable) == null;
            if (!isConstantAndIdentical) continue;
            Token newValue = analysis.getConstantValue(rateVariable);
            if (value == null) {
                value = newValue;
                continue;
            }
            boolean bl2 = isConstantAndIdentical = isConstantAndIdentical && newValue.equals(value);
        }
    }

    protected CompositeActor _getEnclosingDomainActor() throws IllegalActionException {
        CompositeActor container = (CompositeActor)this.getContainer();
        Director director = container.getExecutiveDirector();
        while (director != null) {
            if (director instanceof MultirateFSMDirector) {
                container = (CompositeActor)container.getContainer();
                director = container.getExecutiveDirector();
                continue;
            }
            return container;
        }
        throw new IllegalActionException((Nameable)this, "This director must be contained within another domain.");
    }

    protected List _getRefinementRateVariables(IOPort port, String parameterName) throws IllegalActionException {
        LinkedList<Variable> list = new LinkedList<Variable>();
        for (IOPort insidePort : port.deepInsidePortList()) {
            Variable variable = DFUtilities.getRateVariable((Port)insidePort, (String)parameterName);
            if (variable == null) continue;
            list.add(variable);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean _updateInputTokenConsumptionRates(TypedCompositeActor actor) throws IllegalActionException {
        inputRateChanged = false;
        refineInPortContainer = (CompositeActor)actor.getContainer();
        for (IOPort refineInPort : actor.inputPortList()) {
            inPortsOutside = refineInPort.deepConnectedInPortList().iterator();
            if (inPortsOutside.hasNext()) ** GOTO lbl14
            throw new IllegalActionException("Current state's refining actor has an input port notconnected to an input port of its container.");
lbl-1000:
            // 1 sources

            {
                inputPortOutside = (IOPort)inPortsOutside.next();
                thisPortContainer = (ComponentEntity)inputPortOutside.getContainer();
                if (!thisPortContainer.getFullName().equals(refineInPortContainer.getFullName())) continue;
                previousPortRate = DFUtilities.getTokenConsumptionRate((IOPort)inputPortOutside);
                if (previousPortRate != (portRateToSet = DFUtilities.getTokenConsumptionRate((IOPort)refineInPort))) {
                    inputRateChanged = true;
                }
                DFUtilities.setTokenConsumptionRate((IOPort)inputPortOutside, (int)portRateToSet);
lbl14:
                // 3 sources

                ** while (inPortsOutside.hasNext())
            }
lbl15:
            // 1 sources

        }
        return inputRateChanged;
    }

    protected boolean _updateOutputTokenProductionRates(TypedCompositeActor actor) throws IllegalActionException {
        boolean outputRateChanged = false;
        CompositeActor refineOutPortContainer = (CompositeActor)actor.getContainer();
        for (IOPort refineOutPort : actor.outputPortList()) {
            for (IOPort outputPortOutside : refineOutPort.deepConnectedOutPortList()) {
                ComponentEntity thisPortContainer = (ComponentEntity)outputPortOutside.getContainer();
                if (!thisPortContainer.getFullName().equals(refineOutPortContainer.getFullName())) continue;
                int previousPortRate = DFUtilities.getTokenProductionRate((IOPort)outputPortOutside);
                int portRateToSet = DFUtilities.getTokenProductionRate((IOPort)refineOutPort);
                int portInitRateToSet = DFUtilities.getTokenInitProduction((IOPort)refineOutPort);
                if (previousPortRate != portRateToSet) {
                    outputRateChanged = true;
                }
                DFUtilities.setTokenProductionRate((IOPort)outputPortOutside, (int)portRateToSet);
                DFUtilities.setTokenInitProduction((IOPort)outputPortOutside, (int)portInitRateToSet);
            }
        }
        return outputRateChanged;
    }
}

