/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.InvariantViolationException;
import ptolemy.actor.Mailbox;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.QuasiTransparentDirector;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedActor;
import ptolemy.actor.util.ExplicitChangeContext;
import ptolemy.actor.util.Time;
import ptolemy.data.Token;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.Variable;
import ptolemy.domains.fsm.kernel.AbstractActionsAttribute;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.MultipleEnabledTransitionsException;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.ModelErrorHandler;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class FSMDirector
extends Director
implements ModelErrorHandler,
ExplicitChangeContext,
QuasiTransparentDirector {
    public StringAttribute controllerName = null;
    protected Map _currentLocalReceiverMap = null;
    protected List _enabledRefinements;
    protected Transition _enabledTransition = null;
    protected Map _localReceiverMaps = new HashMap();
    protected boolean _mutationEnabled = true;
    private FSMActor _controller = null;
    private long _controllerVersion = -1L;
    private long _localReceiverMapsVersion = -1L;

    public FSMDirector() {
        this._createAttribute();
    }

    public FSMDirector(Workspace workspace) {
        super(workspace);
        this._createAttribute();
    }

    public FSMDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._createAttribute();
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.controllerName) {
            this._controllerVersion = -1L;
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FSMDirector newObject = (FSMDirector)((Object)super.clone(workspace));
        newObject._controllerVersion = -1L;
        newObject._localReceiverMaps = new HashMap();
        newObject._localReceiverMapsVersion = -1L;
        return newObject;
    }

    public void fire() throws IllegalActionException {
        int i;
        Transition tr;
        FSMActor ctrl = this.getController();
        if (this._debugging) {
            this._debug("Firing " + this.getFullName(), " at time " + this.getModelTime());
        }
        ctrl.readInputs();
        State st = ctrl.currentState();
        this._enabledTransition = tr = ctrl.chooseTransition(st.preemptiveTransitionList());
        if (tr != null) {
            TypedActor[] actors = tr.getRefinement();
            if (actors != null) {
                int i2 = 0;
                while (i2 < actors.length) {
                    if (this._stopRequested) break;
                    if (actors[i2].prefire()) {
                        actors[i2].fire();
                        actors[i2].postfire();
                    }
                    ++i2;
                }
            }
            ctrl.readOutputsFromRefinement();
            return;
        }
        TypedActor[] actors = st.getRefinement();
        if (actors != null) {
            i = 0;
            while (i < actors.length) {
                if (this._stopRequested) break;
                if (actors[i].prefire()) {
                    if (this._debugging) {
                        this._debug(this.getFullName(), " fire refinement", ((NamedObj)actors[i]).getName());
                    }
                    actors[i].fire();
                    actors[i].postfire();
                }
                ++i;
            }
        }
        st.setVisited(true);
        ctrl.readOutputsFromRefinement();
        this._enabledTransition = tr = ctrl.chooseTransition(st.nonpreemptiveTransitionList());
        if (tr != null && (actors = tr.getRefinement()) != null) {
            i = 0;
            while (i < actors.length) {
                if (this._stopRequested) break;
                if (actors[i].prefire()) {
                    if (this._debugging) {
                        this._debug(this.getFullName(), " fire transition refinement", ((NamedObj)actors[i]).getName());
                    }
                    actors[i].fire();
                    actors[i].postfire();
                }
                ++i;
            }
            ctrl.readOutputsFromRefinement();
        }
    }

    public void fireAt(Actor actor, Time time) throws IllegalActionException {
        NamedObj container = this.getContainer();
        if (container instanceof Actor) {
            Actor modalModel = (Actor)container;
            Director executiveDirector = modalModel.getExecutiveDirector();
            if (executiveDirector != null) {
                executiveDirector.fireAt(modalModel, time);
            } else {
                this.setModelTime(time);
            }
        }
    }

    public FSMActor getController() throws IllegalActionException {
        if (this._controllerVersion == this.workspace().getVersion()) {
            return this._controller;
        }
        try {
            this.workspace().getReadAccess();
            String name = this.controllerName.getExpression();
            if (name == null) {
                throw new IllegalActionException((Nameable)this, "No name for mode controller is set.");
            }
            NamedObj container = this.getContainer();
            if (!(container instanceof CompositeActor)) {
                throw new IllegalActionException((Nameable)this, "No controller found.");
            }
            CompositeActor cont = (CompositeActor)container;
            ComponentEntity entity = cont.getEntity(name);
            if (entity == null) {
                throw new IllegalActionException((Nameable)this, "No controller found with name " + name);
            }
            if (!(entity instanceof FSMActor)) {
                throw new IllegalActionException((Nameable)this, (Nameable)entity, "mode controller must be an instance of FSMActor.");
            }
            this._controller = (FSMActor)entity;
            this._controllerVersion = this.workspace().getVersion();
            FSMActor fSMActor = this._controller;
            return fSMActor;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public Entity getContext() {
        return (Entity)this.getContainer();
    }

    public List getModifiedVariables() throws IllegalActionException {
        LinkedList<NamedObj> list = new LinkedList<NamedObj>();
        for (State state : this.getController().entityList()) {
            for (Transition transition : state.outgoingPort.linkedRelationList()) {
                NamedObj object;
                for (AbstractActionsAttribute action : transition.choiceActionList()) {
                    for (String name : action.getDestinationNameList()) {
                        object = action.getDestination(name);
                        if (!(object instanceof Variable)) continue;
                        list.add(object);
                    }
                }
                for (AbstractActionsAttribute action : transition.commitActionList()) {
                    for (String name : action.getDestinationNameList()) {
                        object = action.getDestination(name);
                        if (!(object instanceof Variable)) continue;
                        list.add(object);
                    }
                }
            }
        }
        return list;
    }

    public ParseTreeEvaluator getParseTreeEvaluator() {
        return new ParseTreeEvaluator();
    }

    public boolean handleModelError(NamedObj context, IllegalActionException exception) throws IllegalActionException {
        if (exception instanceof MultipleEnabledTransitionsException) {
            throw exception;
        }
        if (exception instanceof InvariantViolationException) {
            NamedObj container;
            FSMActor controller = this.getController();
            controller.readOutputsFromRefinement();
            State st = controller.currentState();
            List enabledTransitions = controller.enabledTransitions(st.nonpreemptiveTransitionList());
            if (enabledTransitions.size() == 0 && (container = this.getContainer()) != null) {
                throw exception;
            }
            if (this._debugging && this._verbose) {
                this._debug("ModelError " + exception.getMessage() + " is handled.");
            }
            return true;
        }
        return false;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._mutationEnabled = true;
        this._buildLocalReceiverMaps();
    }

    public Receiver newReceiver() {
        return new Mailbox(){

            public boolean hasRoom() {
                return true;
            }

            public void put(Token token) {
                try {
                    if (this.hasToken()) {
                        this.get();
                    }
                    super.put(token);
                }
                catch (NoRoomException ex) {
                    throw new InternalErrorException("One-place buffer: " + ex.getMessage());
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException("One-place buffer: " + ex.getMessage());
                }
            }
        };
    }

    public boolean postfire() throws IllegalActionException {
        CompositeActor container;
        Director executiveDirector;
        if (this._debugging && this._verbose) {
            this._debug(this.getFullName(), "postfire called at time: " + this.getModelTime());
        }
        FSMActor controller = this.getController();
        boolean result = controller.postfire();
        this._currentLocalReceiverMap = (Map)this._localReceiverMaps.get((Object)controller.currentState());
        if (this._enabledTransition != null && (executiveDirector = (container = (CompositeActor)this.getContainer()).getExecutiveDirector()) != null) {
            if (this._debugging) {
                this._debug("Request refiring by " + executiveDirector.getFullName() + " at " + this.getModelTime());
            }
            executiveDirector.fireAt((Actor)container, this.getModelTime());
        }
        return result && !this._stopRequested;
    }

    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Prefire called at time: " + this.getModelTime());
        }
        super.prefire();
        return this.getController().prefire();
    }

    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        if (container != null) {
            container.setModelErrorHandler((ModelErrorHandler)this);
        }
    }

    public void setModelTime(Time newTime) throws IllegalActionException {
        this._currentTime = newTime;
    }

    public boolean transferInputs(IOPort port) throws IllegalActionException {
        if (!port.isInput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, (Nameable)port, "transferInputs: port argument is not an opaqueinput port.");
        }
        boolean transferredToken = false;
        Receiver[][] insideReceivers = this._currentLocalReceivers(port);
        int i = 0;
        while (i < port.getWidth()) {
            try {
                if (port.hasToken(i)) {
                    Token t = port.get(i);
                    if (insideReceivers != null && insideReceivers[i] != null) {
                        int j = 0;
                        while (j < insideReceivers[i].length) {
                            insideReceivers[i][j].put(t);
                            if (this._debugging) {
                                this._debug(this.getFullName(), "transferring input from " + port.getFullName() + " to " + insideReceivers[i][j].getContainer().getFullName());
                            }
                            ++j;
                        }
                        transferredToken = true;
                    }
                } else if (insideReceivers != null && insideReceivers[i] != null) {
                    int j = 0;
                    while (j < insideReceivers[i].length) {
                        if (insideReceivers[i][j].hasToken()) {
                            insideReceivers[i][j].get();
                        }
                        ++j;
                    }
                }
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException("Director.transferInputs: Internal error: " + ex.getMessage());
            }
            ++i;
        }
        return transferredToken;
    }

    protected void _buildLocalReceiverMaps() throws IllegalActionException {
        try {
            this.workspace().getReadAccess();
            FSMActor controller = this.getController();
            this._localReceiverMaps.clear();
            Iterator states = controller.entityList().iterator();
            State state2 = null;
            while (states.hasNext()) {
                state2 = (State)((Object)states.next());
                this._localReceiverMaps.put(state2, new HashMap());
            }
            CompositeActor comp = (CompositeActor)this.getContainer();
            Iterator inPorts = comp.inputPortList().iterator();
            LinkedList<Receiver> resultsList = new LinkedList<Receiver>();
            while (inPorts.hasNext()) {
                IOPort port = (IOPort)inPorts.next();
                Receiver[][] allReceivers = port.deepGetReceivers();
                for (State state2 : controller.entityList()) {
                    TypedActor[] actors = state2.getRefinement();
                    Receiver[][] allReceiversArray = new Receiver[allReceivers.length][0];
                    int i = 0;
                    while (i < allReceivers.length) {
                        resultsList.clear();
                        int j = 0;
                        while (j < allReceivers[i].length) {
                            Receiver receiver = allReceivers[i][j];
                            NamedObj cont = receiver.getContainer().getContainer();
                            if (cont == controller) {
                                resultsList.add(receiver);
                            } else {
                                for (Transition transition : state2.nonpreemptiveTransitionList()) {
                                    this._checkActorsForReceiver(transition.getRefinement(), (Nameable)cont, receiver, resultsList);
                                }
                                LinkedList<State> stateList = new LinkedList<State>();
                                stateList.add(state2);
                                for (Transition transition : state2.preemptiveTransitionList()) {
                                    stateList.add(transition.destinationState());
                                    this._checkActorsForReceiver(transition.getRefinement(), (Nameable)cont, receiver, resultsList);
                                }
                                Iterator nextStates = stateList.iterator();
                                while (nextStates.hasNext()) {
                                    actors = ((State)((Object)nextStates.next())).getRefinement();
                                    this._checkActorsForReceiver(actors, (Nameable)cont, receiver, resultsList);
                                }
                            }
                            ++j;
                        }
                        allReceiversArray[i] = new Receiver[resultsList.size()];
                        Object[] receivers = resultsList.toArray();
                        int j2 = 0;
                        while (j2 < receivers.length) {
                            allReceiversArray[i][j2] = (Receiver)receivers[j2];
                            ++j2;
                        }
                        ++i;
                    }
                    HashMap m = (HashMap)this._localReceiverMaps.get((Object)state2);
                    m.put(port, allReceiversArray);
                }
            }
            this._localReceiverMapsVersion = this.workspace().getVersion();
            this._currentLocalReceiverMap = (Map)this._localReceiverMaps.get((Object)controller.currentState());
        }
        finally {
            this.workspace().doneReading();
        }
    }

    protected List _checkTransition(List transitionList) throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller != null) {
            return controller.enabledTransitions(transitionList);
        }
        throw new IllegalActionException((Nameable)this, "No controller!");
    }

    protected Transition _chooseTransition(List transitionList) throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller != null) {
            return controller.chooseTransition(transitionList);
        }
        throw new IllegalActionException((Nameable)this, "No controller!");
    }

    protected Receiver[][] _currentLocalReceivers(IOPort port) throws IllegalActionException {
        if (this._localReceiverMapsVersion != this.workspace().getVersion()) {
            this._buildLocalReceiverMaps();
        }
        return (Receiver[][])this._currentLocalReceiverMap.get(port);
    }

    protected Transition _getLastChosenTransition() throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller != null) {
            return controller._lastChosenTransition;
        }
        return null;
    }

    protected void _readInputs() throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller != null) {
            controller.readInputs();
        }
    }

    protected void _readOutputsFromRefinement() throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller != null) {
            controller.readOutputsFromRefinement();
        }
    }

    protected void _setCurrentConnectionMap() throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller == null) {
            throw new IllegalActionException((Nameable)this, "No controller!");
        }
        controller._setCurrentConnectionMap();
    }

    protected void _setCurrentState(State state) throws IllegalActionException {
        FSMActor controller = this.getController();
        if (controller == null) {
            throw new IllegalActionException((Nameable)this, "No controller!");
        }
        controller._currentState = state;
    }

    private void _checkActorsForReceiver(TypedActor[] actors, Nameable cont, Receiver receiver, List resultsList) {
        if (actors != null) {
            int k = 0;
            while (k < actors.length) {
                if (cont == actors[k] && !resultsList.contains(receiver)) {
                    resultsList.add(receiver);
                    break;
                }
                ++k;
            }
        }
    }

    private void _createAttribute() {
        try {
            this.controllerName = new StringAttribute((NamedObj)this, "controllerName");
        }
        catch (NameDuplicationException nameDuplicationException) {
            throw new InternalErrorException(String.valueOf(this.getName()) + "Cannot create " + "controllerName attribute.");
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException(String.valueOf(this.getName()) + "Cannot create " + "controllerName attribute.");
        }
    }
}

