/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.Initializable;
import ptolemy.actor.Manager;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.ExplicitChangeContext;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.HasTypeConstraints;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.domains.fsm.kernel.AbstractActionsAttribute;
import ptolemy.domains.fsm.kernel.Action;
import ptolemy.domains.fsm.kernel.FunctionDependencyOfFSMActor;
import ptolemy.domains.fsm.kernel.MultipleEnabledTransitionsException;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.StateEvent;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StreamListener;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class FSMActor
extends CompositeEntity
implements TypedActor,
ExplicitChangeContext {
    public StringAttribute finalStateNames = null;
    public StringAttribute initialStateName = null;
    protected State _currentState = null;
    protected transient List<Initializable> _initializables;
    protected Map _inputTokenMap = new HashMap();
    protected Transition _lastChosenTransition = null;
    protected boolean _stopRequested = false;
    State _initialState = null;
    private transient long _inputPortsVersion = -1L;
    private transient LinkedList _cachedInputPorts;
    private transient long _outputPortsVersion = -1L;
    private transient LinkedList _cachedOutputPorts;
    private Map _connectionMaps = null;
    private long _connectionMapsVersion = -1L;
    private Map _currentConnectionMap = null;
    private HashSet<String> _finalStateNames = null;
    private HashMap _identifierToPort;
    private FunctionDependency _functionDependency;
    private boolean _newIteration = true;
    private boolean _reachedFinalState;
    private long _receiversVersion = -1L;
    private boolean _supportMultirate = false;
    private Hashtable _tokenListArrays;

    public FSMActor() {
        this._init();
    }

    public FSMActor(Workspace workspace) {
        super(workspace);
        this._init();
    }

    public FSMActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public void addInitializable(Initializable initializable) {
        if (this._initializables == null) {
            this._initializables = new LinkedList<Initializable>();
        }
        this._initializables.add(initializable);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.finalStateNames) {
            this._parseFinalStates(this.finalStateNames.getExpression());
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Transition chooseTransition(List transitionList) throws IllegalActionException {
        Transition result = null;
        List enabledTransitions = this.enabledTransitions(transitionList);
        int length = enabledTransitions.size();
        if (length == 1) {
            result = (Transition)((Object)enabledTransitions.get(0));
        } else if (length > 1) {
            for (Transition enabledTransition : enabledTransitions) {
                if (enabledTransition.isNondeterministic()) continue;
                throw new MultipleEnabledTransitionsException((Nameable)this.currentState(), "Multiple enabled transitions found but not all of them are nondeterministic. Transition " + enabledTransition.getName() + " is deterministic.");
            }
            int randomChoice = (int)Math.floor(Math.random() * (double)length);
            if (randomChoice == length) {
                --randomChoice;
            }
            result = (Transition)((Object)enabledTransitions.get(randomChoice));
        }
        if (result != null) {
            if (this._debugging) {
                this._debug("Enabled transition: ", result.getFullName());
            }
            for (Action action : result.choiceActionList()) {
                action.execute();
            }
        }
        this._lastChosenTransition = result;
        return result;
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FSMActor newObject = (FSMActor)((Object)super.clone(workspace));
        newObject._inputPortsVersion = -1L;
        newObject._outputPortsVersion = -1L;
        newObject._connectionMapsVersion = -1L;
        newObject._connectionMaps = null;
        newObject._inputTokenMap = new HashMap();
        newObject._identifierToPort = new HashMap();
        if (this._initialState != null) {
            newObject._initialState = (State)newObject.getEntity(this._initialState.getName());
        }
        return newObject;
    }

    public State currentState() {
        return this._currentState;
    }

    public List enabledTransitions(List transitionList) throws IllegalActionException {
        LinkedList<Transition> enabledTransitions = new LinkedList<Transition>();
        LinkedList<Transition> defaultTransitions = new LinkedList<Transition>();
        Iterator transitionRelations = transitionList.iterator();
        while (transitionRelations.hasNext() && !this._stopRequested) {
            Transition transition = (Transition)((Object)transitionRelations.next());
            if (transition.isDefault()) {
                defaultTransitions.add(transition);
                continue;
            }
            if (!transition.isEnabled()) continue;
            enabledTransitions.add(transition);
        }
        if (enabledTransitions.size() > 0) {
            return enabledTransitions;
        }
        return defaultTransitions;
    }

    public void fire() throws IllegalActionException {
        this.readInputs();
        List transitionList = this._currentState.outgoingPort.linkedRelationList();
        this.chooseTransition(transitionList);
    }

    public Entity getContext() {
        return this;
    }

    public Director getDirector() {
        CompositeEntity container = (CompositeEntity)this.getContainer();
        if (container instanceof CompositeActor) {
            return ((CompositeActor)container).getDirector();
        }
        return null;
    }

    public Director getExecutiveDirector() {
        return this.getDirector();
    }

    public State getInitialState() throws IllegalActionException {
        String name = this.initialStateName.getExpression();
        if (!name.equals("")) {
            try {
                this.workspace().getReadAccess();
                State state = (State)this.getEntity(name);
                if (state == null) {
                    throw new IllegalActionException((Nameable)this, "Cannot find initial state with name \"" + name + "\".");
                }
                state.isInitialState.setToken("true");
                State state2 = this._initialState;
                return state2;
            }
            finally {
                this.workspace().doneReading();
            }
        }
        if (this._initialState == null) {
            throw new IllegalActionException((Nameable)this, "No initial state has been specified.");
        }
        return this._initialState;
    }

    public FunctionDependency getFunctionDependency() {
        if (this._functionDependency == null) {
            try {
                this._functionDependency = new FunctionDependencyOfFSMActor(this);
            }
            catch (NameDuplicationException nameDuplicationException) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
            catch (IllegalActionException illegalActionException) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
        }
        return this._functionDependency;
    }

    public Manager getManager() {
        try {
            this._workspace.getReadAccess();
            CompositeEntity container = (CompositeEntity)this.getContainer();
            if (container instanceof CompositeActor) {
                Manager manager = ((CompositeActor)container).getManager();
                return manager;
            }
            return null;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public List getModifiedVariables() throws IllegalActionException {
        LinkedList<NamedObj> list = new LinkedList<NamedObj>();
        for (State state : this.entityList()) {
            for (Transition transition : state.outgoingPort.linkedRelationList()) {
                NamedObj object;
                for (AbstractActionsAttribute action : transition.choiceActionList()) {
                    for (String name : action.getDestinationNameList()) {
                        object = action.getDestination(name);
                        if (!(object instanceof Variable) || !this.deepContains(object)) continue;
                        list.add(object);
                    }
                }
                for (AbstractActionsAttribute action : transition.commitActionList()) {
                    for (String name : action.getDestinationNameList()) {
                        object = action.getDestination(name);
                        if (!(object instanceof Variable) || !this.deepContains(object)) continue;
                        list.add(object);
                    }
                }
            }
        }
        return list;
    }

    public ParserScope getPortScope() {
        return new PortScope();
    }

    public void initialize() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.initialize();
            }
        }
        this.reset();
        this._receiversVersion = this.workspace().getVersion();
        for (State state : this.deepEntityList()) {
            state.setVisited(false);
        }
    }

    public List inputPortList() {
        if (this._inputPortsVersion != this._workspace.getVersion()) {
            try {
                this._workspace.getReadAccess();
                LinkedList<IOPort> inPorts = new LinkedList<IOPort>();
                for (IOPort p : this.portList()) {
                    if (!p.isInput()) continue;
                    inPorts.add(p);
                }
                this._cachedInputPorts = inPorts;
                this._inputPortsVersion = this._workspace.getVersion();
            }
            finally {
                this._workspace.doneReading();
            }
        }
        return this._cachedInputPorts;
    }

    public boolean isFireFunctional() {
        return false;
    }

    public boolean isOpaque() {
        return true;
    }

    public boolean isStrict() {
        return true;
    }

    public int iterate(int count) throws IllegalActionException {
        int n = 0;
        while (n++ < count && !this._stopRequested) {
            if (this.prefire()) {
                this.fire();
                if (this.postfire()) continue;
                return 2;
            }
            return 1;
        }
        if (this._stopRequested) {
            return 2;
        }
        return 0;
    }

    public Port newPort(String name) throws NameDuplicationException {
        try {
            this._workspace.getWriteAccess();
            TypedIOPort typedIOPort = new TypedIOPort((ComponentEntity)this, name);
            return typedIOPort;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("TypedAtomicActor.newPort: Internal error: " + ex.getMessage());
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public Receiver newReceiver() throws IllegalActionException {
        Director director = this.getDirector();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, "Cannot create a receiver without a director.");
        }
        return director.newReceiver();
    }

    public ComponentRelation newRelation(String name) throws IllegalActionException, NameDuplicationException {
        try {
            Transition tr;
            this.workspace().getWriteAccess();
            Transition transition = tr = new Transition(this, name);
            return transition;
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    public List outputPortList() {
        if (this._outputPortsVersion != this._workspace.getVersion()) {
            try {
                this._workspace.getReadAccess();
                this._cachedOutputPorts = new LinkedList();
                for (IOPort p : this.portList()) {
                    if (!p.isOutput()) continue;
                    this._cachedOutputPorts.add(p);
                }
                this._outputPortsVersion = this._workspace.getVersion();
            }
            finally {
                this._workspace.doneReading();
            }
        }
        return this._cachedOutputPorts;
    }

    public boolean postfire() throws IllegalActionException {
        this._commitLastChosenTransition();
        return !this._reachedFinalState && !this._stopRequested;
    }

    public boolean prefire() throws IllegalActionException {
        this._lastChosenTransition = null;
        return true;
    }

    public void preinitialize() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.preinitialize();
            }
        }
        this._stopRequested = false;
        this._reachedFinalState = false;
        if (this._receiversVersion != this.workspace().getVersion()) {
            this._createReceivers();
            this._receiversVersion = this.workspace().getVersion();
        } else {
            this._resetReceivers();
        }
        this._newIteration = true;
        this._tokenListArrays = new Hashtable();
        this._identifierToPort.clear();
        for (IOPort inPort : this.inputPortList()) {
            this._setIdentifierToPort(inPort.getName(), (Port)inPort);
            this._setIdentifierToPort(String.valueOf(inPort.getName()) + "_isPresent", (Port)inPort);
            this._setIdentifierToPort(String.valueOf(inPort.getName()) + "Array", (Port)inPort);
            int i = 0;
            while (i < inPort.getWidth()) {
                this._setIdentifierToPort(String.valueOf(inPort.getName()) + "_" + i, (Port)inPort);
                this._setIdentifierToPort(String.valueOf(inPort.getName()) + "_" + i + "_isPresent", (Port)inPort);
                this._setIdentifierToPort(String.valueOf(inPort.getName()) + "_" + i + "Array", (Port)inPort);
                ++i;
            }
        }
        this._inputTokenMap.clear();
        this.reset();
    }

    public void readInputs() throws IllegalActionException {
        Iterator inPorts = this.inputPortList().iterator();
        while (inPorts.hasNext() && !this._stopRequested) {
            IOPort p = (IOPort)inPorts.next();
            int width = p.getWidth();
            int channel = 0;
            while (channel < width) {
                this._readInputs(p, channel);
                ++channel;
            }
        }
    }

    public void readOutputsFromRefinement() throws IllegalActionException {
        Iterator inPorts = this.inputPortList().iterator();
        while (inPorts.hasNext() && !this._stopRequested) {
            IOPort p = (IOPort)inPorts.next();
            int width = p.getWidth();
            int channel = 0;
            while (channel < width) {
                if (this._isRefinementOutput(p, channel)) {
                    this._readInputs(p, channel);
                }
                ++channel;
            }
        }
    }

    public void removeInitializable(Initializable initializable) {
        if (this._initializables != null) {
            this._initializables.remove(initializable);
            if (this._initializables.size() == 0) {
                this._initializables = null;
            }
        }
    }

    public void reset() throws IllegalActionException {
        this._currentState = this.getInitialState();
        if (this._debugging) {
            this._debug(new StateEvent(this, this._currentState));
        }
        this._setCurrentConnectionMap();
    }

    public void setNewIteration(boolean newIteration) {
        this._newIteration = newIteration;
    }

    public void setSupportMultirate(boolean supportMultirate) {
        this._supportMultirate = supportMultirate;
    }

    public void stop() {
        this._stopRequested = true;
    }

    public void stopFire() {
    }

    public void terminate() {
        this.stop();
    }

    public List typeConstraintList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            for (Typeable port : this.portList()) {
                result.addAll(port.typeConstraintList());
            }
            for (HasTypeConstraints typeableAttribute : this.attributeList(HasTypeConstraints.class)) {
                result.addAll(typeableAttribute.typeConstraintList());
            }
            for (Relation tr : this.relationList()) {
                for (HasTypeConstraints typeableAttribute : tr.attributeList(HasTypeConstraints.class)) {
                    result.addAll(typeableAttribute.typeConstraintList());
                }
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void wrapup() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.initialize();
            }
        }
    }

    protected void _addEntity(ComponentEntity entity) throws IllegalActionException, NameDuplicationException {
        if (!(entity instanceof State)) {
            throw new IllegalActionException((Nameable)this, (Nameable)entity, "FSMActor can only contain entities that are instances of State.");
        }
        super._addEntity(entity);
    }

    protected void _addRelation(ComponentRelation relation) throws IllegalActionException, NameDuplicationException {
        if (!(relation instanceof Transition)) {
            throw new IllegalActionException((Nameable)this, (Nameable)relation, "FSMActor can only contain instances of Transition.");
        }
        super._addRelation(relation);
        if (this._debugging) {
            relation.addDebugListener((DebugListener)new StreamListener());
        }
    }

    protected void _commitLastChosenTransition() throws IllegalActionException {
        BooleanToken resetToken;
        if (this._lastChosenTransition == null) {
            return;
        }
        if (this._debugging) {
            this._debug("Commit transition ", this._lastChosenTransition.getFullName());
        }
        if (this._lastChosenTransition.destinationState() == null) {
            throw new IllegalActionException((Nameable)this, (Nameable)this._lastChosenTransition, "The transition is enabled but does not have a destination state.");
        }
        TypedActor[] actors = this._lastChosenTransition.destinationState().getRefinement();
        if (actors != null) {
            int i = 0;
            while (i < actors.length) {
                actors[i].getDirector().setModelTime(this.getExecutiveDirector().getModelTime());
                ++i;
            }
        }
        Iterator actions = this._lastChosenTransition.commitActionList().iterator();
        while (actions.hasNext() && !this._stopRequested) {
            Action action = (Action)((Object)actions.next());
            action.execute();
        }
        this._currentState = this._lastChosenTransition.destinationState();
        if (((BooleanToken)this._currentState.isFinalState.getToken()).booleanValue()) {
            this._reachedFinalState = true;
        } else if (this._finalStateNames != null && this._finalStateNames.contains(this._currentState.getName())) {
            this._reachedFinalState = true;
        }
        if (this._debugging) {
            this._debug(new StateEvent(this, this._currentState));
        }
        if ((resetToken = (BooleanToken)this._lastChosenTransition.reset.getToken()).booleanValue()) {
            actors = this._currentState.getRefinement();
            if (actors != null) {
                int i = 0;
                while (i < actors.length) {
                    if (this._debugging) {
                        this._debug(String.valueOf(this.getFullName()) + " initialize refinement: " + ((NamedObj)actors[i]).getName());
                    }
                    actors[i].initialize();
                    ++i;
                }
            }
            this._currentState.setVisited(false);
        }
        this._setCurrentConnectionMap();
    }

    protected boolean _isRefinementOutput(IOPort port, int channel) throws IllegalActionException {
        TypedActor[] refinements = this._currentState.getRefinement();
        if (refinements == null || refinements.length == 0) {
            return false;
        }
        if (this._connectionMapsVersion != this.workspace().getVersion()) {
            this._setCurrentConnectionMap();
        }
        boolean[] flags = (boolean[])this._currentConnectionMap.get(port);
        return flags[channel];
    }

    protected void _setCurrentConnectionMap() throws IllegalActionException {
        if (this._connectionMapsVersion != this.workspace().getVersion()) {
            this._buildConnectionMaps();
        }
        this._currentConnectionMap = (Map)this._connectionMaps.get((Object)this._currentState);
    }

    protected void _readInputs(IOPort port, int channel) throws IllegalActionException {
        String portName = port.getName();
        String portChannelName = String.valueOf(portName) + "_" + channel;
        if (port.getContainer() != this) {
            throw new IllegalActionException((Nameable)this, (Nameable)port, "Cannot read inputs from port not contained by this FSMActor.");
        }
        if (!port.isInput()) {
            return;
        }
        if (port.isKnown(channel)) {
            if (this._supportMultirate) {
                int length;
                LinkedList[] tokenListArray;
                int width = port.getWidth();
                if (this._newIteration && channel == 0) {
                    tokenListArray = new LinkedList[width];
                    int i = 0;
                    while (i < width) {
                        tokenListArray[i] = new LinkedList();
                        ++i;
                    }
                    this._tokenListArrays.put(port, tokenListArray);
                }
                tokenListArray = (LinkedList[])this._tokenListArrays.get(port);
                while (port.hasToken(channel)) {
                    Token token = port.get(channel);
                    if (this._debugging) {
                        this._debug("---", port.getName(), "(" + channel + ") has ", token.toString());
                    }
                    tokenListArray[channel].add(0, token);
                }
                if (this._debugging) {
                    this._debug("Total tokens available at port: " + port.getFullName() + "  ");
                }
                if ((length = tokenListArray[channel].size()) > 0) {
                    Token[] tokens = new Token[length];
                    tokenListArray[channel].toArray(tokens);
                    this._setInputTokenMap(String.valueOf(portName) + "_isPresent", (Port)port, (Token)BooleanToken.TRUE);
                    this._setInputTokenMap(String.valueOf(portChannelName) + "_isPresent", (Port)port, (Token)BooleanToken.TRUE);
                    this._setInputTokenMap(portName, (Port)port, tokens[0]);
                    this._setInputTokenMap(portChannelName, (Port)port, tokens[0]);
                    ArrayToken arrayToken = new ArrayToken(tokens);
                    this._setInputTokenMap(String.valueOf(portName) + "Array", (Port)port, (Token)arrayToken);
                    this._setInputTokenMap(String.valueOf(portChannelName) + "Array", (Port)port, (Token)arrayToken);
                } else {
                    this._setInputTokenMap(String.valueOf(portName) + "_isPresent", (Port)port, (Token)BooleanToken.FALSE);
                    this._setInputTokenMap(String.valueOf(portChannelName) + "_isPresent", (Port)port, (Token)BooleanToken.FALSE);
                    if (this._debugging) {
                        this._debug("---", port.getName(), "(" + channel + ") has no token.");
                    }
                }
            } else if (port.hasToken(channel)) {
                Token token = port.get(channel);
                if (this._debugging) {
                    this._debug("---", port.getName(), "(" + channel + ") has ", token.toString());
                }
                this._setInputTokenMap(String.valueOf(portName) + "_isPresent", (Port)port, (Token)BooleanToken.TRUE);
                this._setInputTokenMap(String.valueOf(portChannelName) + "_isPresent", (Port)port, (Token)BooleanToken.TRUE);
                this._setInputTokenMap(portName, (Port)port, token);
                this._setInputTokenMap(portChannelName, (Port)port, token);
            } else {
                this._setInputTokenMap(String.valueOf(portName) + "_isPresent", (Port)port, (Token)BooleanToken.FALSE);
                this._setInputTokenMap(String.valueOf(portChannelName) + "_isPresent", (Port)port, (Token)BooleanToken.FALSE);
                if (this._debugging) {
                    this._debug("---", port.getName(), "(" + channel + ") has no token.");
                }
            }
        }
    }

    private void _buildConnectionMaps() throws IllegalActionException {
        try {
            this.workspace().getReadAccess();
            if (this._connectionMaps == null) {
                this._connectionMaps = new HashMap();
            } else {
                this._connectionMaps.clear();
            }
            Iterator states = this.entityList().iterator();
            State state = null;
            while (states.hasNext()) {
                state = (State)((Object)states.next());
                HashMap<IOPort, boolean[]> stateMap = new HashMap<IOPort, boolean[]>();
                TypedActor[] actors = state.getRefinement();
                for (IOPort inPort : this.inputPortList()) {
                    boolean[] flags = new boolean[inPort.getWidth()];
                    if (actors == null || actors.length == 0) {
                        Arrays.fill(flags, false);
                        stateMap.put(inPort, flags);
                        continue;
                    }
                    Iterator relations = inPort.linkedRelationList().iterator();
                    int channelIndex = 0;
                    while (relations.hasNext()) {
                        IORelation relation = (IORelation)relations.next();
                        boolean linked = false;
                        int i = 0;
                        while (i < actors.length) {
                            for (IOPort outport : actors[i].outputPortList()) {
                                linked |= outport.isLinked((Relation)relation);
                            }
                            ++i;
                        }
                        int j = 0;
                        while (j < relation.getWidth()) {
                            flags[channelIndex + j] = linked;
                            ++j;
                        }
                        channelIndex += relation.getWidth();
                    }
                    stateMap.put(inPort, flags);
                }
                this._connectionMaps.put(state, stateMap);
            }
            this._connectionMapsVersion = this.workspace().getVersion();
        }
        finally {
            this.workspace().doneReading();
        }
    }

    private void _parseFinalStates(String names) {
        StringTokenizer nameTokens = new StringTokenizer(names, ",");
        while (nameTokens.hasMoreElements()) {
            String name = (String)nameTokens.nextElement();
            name = name.trim();
            if (this._finalStateNames == null) {
                this._finalStateNames = new HashSet();
            }
            this._finalStateNames.add(name);
        }
    }

    private void _createReceivers() throws IllegalActionException {
        try {
            this.workspace().getWriteAccess();
            for (IOPort inPort : this.inputPortList()) {
                inPort.createReceivers();
            }
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    private void _init() {
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-28\" y=\"-18\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<ellipse cx=\"0\" cy=\"0\" rx=\"15\" ry=\"10\"/>\n<circle cx=\"-15\" cy=\"0\" r=\"5\" style=\"fill:white\"/>\n<circle cx=\"15\" cy=\"0\" r=\"5\" style=\"fill:white\"/>\n</svg>\n");
        try {
            this.initialStateName = new StringAttribute((NamedObj)this, "initialStateName");
            this.initialStateName.setExpression("");
            this.initialStateName.setVisibility(Settable.EXPERT);
            this.finalStateNames = new StringAttribute((NamedObj)this, "finalStateNames");
            this.finalStateNames.setExpression("");
            this.finalStateNames.setVisibility(Settable.EXPERT);
        }
        catch (KernelException ex) {
            throw new InternalErrorException("Constructor error " + ex.getMessage());
        }
        this._identifierToPort = new HashMap();
    }

    private void _resetReceivers() throws IllegalActionException {
        for (IOPort inPort : this.inputPortList()) {
            Receiver[][] receivers = inPort.getReceivers();
            int i = 0;
            while (i < receivers.length) {
                if (receivers[i] != null) {
                    int j = 0;
                    while (j < receivers[i].length) {
                        if (receivers[i][j] != null) {
                            receivers[i][j].reset();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void _setIdentifierToPort(String name, Port inputPort) throws IllegalActionException {
        Port previousPort = (Port)this._identifierToPort.get(name);
        if (previousPort != null && previousPort != inputPort) {
            throw new IllegalActionException("Name conflict in finite state machine.  The identifier \"" + name + "\" is associated with the port " + previousPort + " and with the port " + inputPort);
        }
        this._identifierToPort.put(name, inputPort);
    }

    private void _setInputTokenMap(String name, Port inputPort, Token token) throws IllegalActionException {
        this._setIdentifierToPort(name, inputPort);
        this._inputTokenMap.put(name, token);
    }

    private class PortScope
    extends ModelScope {
        private PortScope() {
        }

        public Token get(String name) throws IllegalActionException {
            Token token = (Token)FSMActor.this._inputTokenMap.get(name);
            if (token != null) {
                return token;
            }
            Variable result = PortScope.getScopedVariable(null, (NamedObj)FSMActor.this, (String)name);
            if (result != null) {
                return result.getToken();
            }
            return null;
        }

        public Type getType(String name) throws IllegalActionException {
            Port port = (Port)FSMActor.this._identifierToPort.get(name);
            if (port != null && port instanceof Typeable) {
                if (name.endsWith("_isPresent")) {
                    return BaseType.BOOLEAN;
                }
                if (name.endsWith("Array")) {
                    String portName = name.substring(0, name.length() - 5);
                    if (port == FSMActor.this._identifierToPort.get(portName)) {
                        Type portType = ((Typeable)port).getType();
                        return new ArrayType(portType);
                    }
                }
                return ((Typeable)port).getType();
            }
            Variable result = PortScope.getScopedVariable(null, (NamedObj)FSMActor.this, (String)name);
            if (result != null) {
                return result.getType();
            }
            return null;
        }

        public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
            Port port = (Port)FSMActor.this._identifierToPort.get(name);
            if (port != null && port instanceof Typeable) {
                return ((Typeable)port).getTypeTerm();
            }
            Variable result = PortScope.getScopedVariable(null, (NamedObj)FSMActor.this, (String)name);
            if (result != null) {
                return result.getTypeTerm();
            }
            return null;
        }

        public Set identifierSet() {
            Set set = PortScope.getAllScopedVariableNames(null, (NamedObj)FSMActor.this);
            set.addAll(FSMActor.this._identifierToPort.keySet());
            return set;
        }
    }
}

