/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.AddSubtract;
import ptolemy.actor.lib.Scale;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.ct.lib.Integrator;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class LinearStateSpace
extends TypedCompositeActor {
    public TypedIOPort input = new TypedIOPort((ComponentEntity)this, "input", true, false);
    public TypedIOPort output;
    public TypedIOPort stateOutput;
    public Parameter A;
    public Parameter B;
    public Parameter C;
    public Parameter D;
    public Parameter initialStates;
    private boolean _opaque;
    private boolean _requestInitialization;

    public LinearStateSpace(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setMultiport(true);
        this.stateOutput = new TypedIOPort((ComponentEntity)this, "stateOutput", false, true);
        this.stateOutput.setMultiport(true);
        this._opaque = true;
        this._requestInitialization = true;
        double[][] one = new double[][]{{1.0}};
        double[][] zero = new double[][]{{0.0}};
        this.A = new Parameter((NamedObj)this, "A", (Token)new DoubleMatrixToken((double[][])one));
        this.A.setTypeEquals((Type)BaseType.DOUBLE_MATRIX);
        this.B = new Parameter((NamedObj)this, "B", (Token)new DoubleMatrixToken((double[][])one));
        this.B.setTypeEquals((Type)BaseType.DOUBLE_MATRIX);
        this.C = new Parameter((NamedObj)this, "C", (Token)new DoubleMatrixToken((double[][])one));
        this.C.setTypeEquals((Type)BaseType.DOUBLE_MATRIX);
        this.D = new Parameter((NamedObj)this, "D", (Token)new DoubleMatrixToken((double[][])zero));
        this.D.setTypeEquals((Type)BaseType.DOUBLE_MATRIX);
        this.initialStates = new Parameter((NamedObj)this, "initialStates", (Token)new DoubleMatrixToken((double[][])zero));
        this.initialStates.setTypeEquals((Type)BaseType.DOUBLE_MATRIX);
        this.setClassName("ptolemy.domains.ct.lib.LinearStateSpace");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-50\" y=\"-30\" width=\"100\" height=\"60\" style=\"fill:white\"/>\n<text x=\"-45\" y=\"-10\" style=\"font-size:14\">\ndx/dt=Ax+Bu </text>\n<text x=\"-45\" y=\"10\" style=\"font-size:14\">\n    y=Cx+Du</text>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.A) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.A.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0 || token.getRowCount() != token.getColumnCount()) {
                throw new IllegalActionException((Nameable)this, "The A matrix must be a nonempty square matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.B) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.B.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The B matrix must be a nonempty matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.C) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.C.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The C matrix must be a nonempty matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.D) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.D.getToken();
            if (token.getRowCount() == 0 || token.getColumnCount() == 0) {
                throw new IllegalActionException((Nameable)this, "The D matrix must be a nonempty matrix.");
            }
            this._requestInitialization = true;
        } else if (attribute == this.initialStates) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.initialStates.getToken();
            if (token.getRowCount() != 1 || token.getColumnCount() < 1) {
                throw new IllegalActionException((Nameable)this, "The initialStates must be a row vector.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Director getDirector() {
        if (this._opaque) {
            return null;
        }
        return this.getExecutiveDirector();
    }

    public boolean isOpaque() {
        return this._opaque;
    }

    public boolean postfire() throws IllegalActionException {
        if (this._requestInitialization) {
            this._requestInitialization();
        }
        return super.postfire();
    }

    public void preinitialize() throws IllegalActionException {
        this._checkParameters();
        DoubleMatrixToken a = (DoubleMatrixToken)this.A.getToken();
        int n = a.getRowCount();
        DoubleMatrixToken b = (DoubleMatrixToken)this.B.getToken();
        int m = b.getColumnCount();
        DoubleMatrixToken c = (DoubleMatrixToken)this.C.getToken();
        int r = c.getRowCount();
        this.D.getToken();
        this.initialStates.getToken();
        try {
            try {
                this._workspace.getWriteAccess();
                this.removeAllEntities();
                this.removeAllRelations();
                Integrator[] integrators = new Integrator[n];
                IORelation[] states = new IORelation[n];
                AddSubtract[] stateAdders = new AddSubtract[n];
                int i = 0;
                while (i < n) {
                    integrators[i] = new Integrator((CompositeEntity)this, "state_" + i);
                    integrators[i].initialState.setExpression("initialStates(0," + i + ")");
                    states[i] = new TypedIORelation((CompositeEntity)this, "relation_state_" + i);
                    integrators[i].output.link((Relation)states[i]);
                    stateAdders[i] = new AddSubtract((CompositeEntity)this, "stateAdder_" + i);
                    this.connect((ComponentPort)stateAdders[i].output, (ComponentPort)integrators[i].input);
                    this.stateOutput.link((Relation)states[i]);
                    ++i;
                }
                Scale[][] feedback = new Scale[n][n];
                int i2 = 0;
                while (i2 < n) {
                    int j = 0;
                    while (j < n) {
                        feedback[i2][j] = new Scale((CompositeEntity)this, "feedback_" + i2 + "_" + j);
                        feedback[i2][j].factor.setExpression("A(" + i2 + ", " + j + ")");
                        feedback[i2][j].input.link((Relation)states[j]);
                        this.connect((ComponentPort)feedback[i2][j].output, (ComponentPort)stateAdders[i2].plus);
                        ++j;
                    }
                    ++i2;
                }
                Scale[][] inputScales = new Scale[n][m];
                IORelation[] inputs = new IORelation[m];
                int j = 0;
                while (j < m) {
                    inputs[j] = new TypedIORelation((CompositeEntity)this, "relation_input_" + j);
                    this.input.link((Relation)inputs[j]);
                    int i3 = 0;
                    while (i3 < n) {
                        inputScales[i3][j] = new Scale((CompositeEntity)this, "b_" + i3 + "_" + j);
                        inputScales[i3][j].factor.setExpression("B(" + i3 + ", " + j + ")");
                        inputScales[i3][j].input.link((Relation)inputs[j]);
                        this.connect((ComponentPort)inputScales[i3][j].output, (ComponentPort)stateAdders[i3].plus);
                        ++i3;
                    }
                    ++j;
                }
                AddSubtract[] outputAdders = new AddSubtract[r];
                Scale[][] outputScales = new Scale[r][n];
                int l = 0;
                while (l < r) {
                    outputAdders[l] = new AddSubtract((CompositeEntity)this, "outputAdder" + l);
                    this.connect((ComponentPort)outputAdders[l].output, (ComponentPort)this.output);
                    int i4 = 0;
                    while (i4 < n) {
                        outputScales[l][i4] = new Scale((CompositeEntity)this, "outputScale_" + l + "_" + i4);
                        outputScales[l][i4].factor.setExpression("C(" + l + ", " + i4 + ")");
                        outputScales[l][i4].input.link((Relation)states[i4]);
                        this.connect((ComponentPort)outputScales[l][i4].output, (ComponentPort)outputAdders[l].plus);
                        ++i4;
                    }
                    ++l;
                }
                Scale[][] feedThrough = new Scale[r][m];
                int l2 = 0;
                while (l2 < r) {
                    int j2 = 0;
                    while (j2 < m) {
                        feedThrough[l2][j2] = new Scale((CompositeEntity)this, "feedThrough_" + l2 + "_" + j2);
                        feedThrough[l2][j2].factor.setExpression("D(" + l2 + ", " + j2 + ")");
                        feedThrough[l2][j2].input.link((Relation)inputs[j2]);
                        this.connect((ComponentPort)feedThrough[l2][j2].output, (ComponentPort)outputAdders[l2].plus);
                        ++j2;
                    }
                    ++l2;
                }
                this._opaque = false;
                this._workspace.incrVersion();
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException("Duplicated name when constructing the subsystem" + ex.getMessage());
            }
        }
        finally {
            this._workspace.doneWriting();
        }
        for (Actor actor : this.deepEntityList()) {
            actor.preinitialize();
        }
    }

    public void stopFire() {
    }

    public void wrapup() throws IllegalActionException {
        this._opaque = true;
        super.wrapup();
    }

    private void _checkParameters() throws IllegalActionException {
        DoubleMatrixToken a = (DoubleMatrixToken)this.A.getToken();
        int n = a.getRowCount();
        DoubleMatrixToken b = (DoubleMatrixToken)this.B.getToken();
        if (b.getRowCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of rows of the B matrix (" + b.getRowCount() + ") should be equal to " + "the number of rows of the A matrix (" + n + ").");
        }
        int m = b.getColumnCount();
        if (this.input.getWidth() != m) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the B matrix (" + b.getColumnCount() + ") should be equal to " + "the width of the input port (" + this.input.getWidth() + ").");
        }
        DoubleMatrixToken c = (DoubleMatrixToken)this.C.getToken();
        if (c.getColumnCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the C matrix (" + c.getColumnCount() + ") should be equal to " + "the number of rows of the A matrix (" + n + ").");
        }
        DoubleMatrixToken d = (DoubleMatrixToken)this.D.getToken();
        if (c.getRowCount() != d.getRowCount()) {
            throw new IllegalActionException((Nameable)this, "The number of rows of the D matrix (" + d.getRowCount() + ") should be equal to " + "the number of rows of the C matrix (" + c.getRowCount() + ").");
        }
        if (d.getColumnCount() != this.input.getWidth()) {
            throw new IllegalActionException((Nameable)this, "The number of columns of the D matrix (" + d.getColumnCount() + ") should be equal to " + "the width of the input port (" + this.input.getWidth() + ").");
        }
        DoubleMatrixToken x0 = (DoubleMatrixToken)this.initialStates.getToken();
        if (x0.getColumnCount() != n) {
            throw new IllegalActionException((Nameable)this, "The number of initial states (" + x0.getColumnCount() + ") should equal to " + "the number of columns of the A matrix (" + n + ").");
        }
    }

    private void _requestInitialization() {
        Director dir = this.getDirector();
        if (dir != null) {
            dir.requestInitialization((Actor)this);
        }
        this._opaque = true;
    }
}

