/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTWaveformGenerator;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class FirstOrderHold
extends Transformer
implements CTWaveformGenerator {
    public TypedIOPort derivative = new TypedIOPort((ComponentEntity)this, "derivative", true, false);
    public Parameter defaultDerivative;
    public Parameter defaultValue = new Parameter((NamedObj)this, "defaultValue");
    private double _value;
    private double _derivative;
    private Time _time;

    public FirstOrderHold(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.defaultValue.setExpression("0.0");
        this.defaultDerivative = new Parameter((NamedObj)this, "defaultDerivative");
        this.defaultDerivative.setExpression("0.0");
        this.input.setTypeEquals((Type)BaseType.DOUBLE);
        this.derivative.setTypeEquals((Type)BaseType.DOUBLE);
        this.output.setTypeEquals((Type)BaseType.DOUBLE);
        new Parameter((NamedObj)this.input, "signalType", (Token)new StringToken("DISCRETE"));
        new Parameter((NamedObj)this.derivative, "signalType", (Token)new StringToken("DISCRETE"));
        new Parameter((NamedObj)this.output, "signalType", (Token)new StringToken("CONTINUOUS"));
    }

    public void fire() throws IllegalActionException {
        super.fire();
        CTDirector director = (CTDirector)this.getDirector();
        if (director.isDiscretePhase()) {
            if (this.input.hasToken(0) && !this.derivative.hasToken(0) || !this.input.hasToken(0) && this.derivative.hasToken(0)) {
                throw new IllegalActionException((Nameable)this, " No synchronized inputs.");
            }
            if (this.input.hasToken(0) && this.derivative.hasToken(0)) {
                this._value = ((DoubleToken)this.input.get(0)).doubleValue();
                this._derivative = ((DoubleToken)this.derivative.get(0)).doubleValue();
                this._time = director.getModelTime();
                if (this._debugging) {
                    this._debug(this.getFullName(), " get inputs: (" + this._value, ", " + this._derivative + ").");
                }
            }
        }
        double timeInterval = director.getModelTime().subtract(this._time).getDoubleValue();
        this.output.send(0, (Token)new DoubleToken(this._value + timeInterval * this._derivative));
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._value = ((DoubleToken)this.defaultValue.getToken()).doubleValue();
        this._derivative = ((DoubleToken)this.defaultDerivative.getToken()).doubleValue();
        this._time = this.getDirector().getModelTime();
    }
}

