/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.lib.TimedSource;
import ptolemy.actor.util.Time;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class DiscreteClock
extends TimedSource {
    public Parameter numberOfCycles;
    public Parameter offsets;
    public Parameter period = new Parameter((NamedObj)this, "period");
    public Parameter values;
    protected transient Token _currentValue;
    protected transient int _cycleCount;
    protected transient Time _cycleStartTime;
    protected transient boolean _done;
    protected transient double[] _offsets;
    protected transient int _phase;
    protected transient Time _startTime;
    protected transient Token _tentativeCurrentValue;
    protected transient int _tentativeCycleCount;
    protected transient int _tentativeCycleCountIncrement;
    protected transient Time _tentativeCycleStartTime;
    protected transient boolean _tentativeDone;
    protected transient Time _tentativeNextFiringTime;
    protected transient int _tentativePhase;
    protected transient Time _tentativeStartTime;

    public DiscreteClock(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.period.setExpression("2.0");
        this.period.setTypeEquals((Type)BaseType.DOUBLE);
        this.offsets = new Parameter((NamedObj)this, "offsets");
        this.offsets.setExpression("{0.0, 1.0}");
        this.offsets.setTypeEquals((Type)new ArrayType((Type)BaseType.DOUBLE));
        this.attributeChanged((Attribute)this.offsets);
        this.values = new Parameter((NamedObj)this, "values");
        this.values.setExpression("{1, 0}");
        this.output.setTypeAtLeast(ArrayType.elementType((Typeable)this.values));
        this.attributeChanged((Attribute)this.values);
        this.numberOfCycles = new Parameter((NamedObj)this, "numberOfCycles");
        this.numberOfCycles.setTypeEquals((Type)BaseType.INT);
        this.numberOfCycles.setExpression("-1");
        new Parameter((NamedObj)this.output, "signalType", (Token)new StringToken("DISCRETE"));
        new Parameter((NamedObj)this.trigger, "signalType", (Token)new StringToken("DISCRETE"));
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.offsets) {
            ArrayToken offsetsValue = (ArrayToken)this.offsets.getToken();
            this._offsets = new double[offsetsValue.length()];
            double previous = 0.0;
            int i = 0;
            while (i < offsetsValue.length()) {
                this._offsets[i] = ((DoubleToken)offsetsValue.getElement(i)).doubleValue();
                if (this._offsets[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of offsets is not nondecreasing and nonnegative.");
                }
                previous = this._offsets[i];
                ++i;
            }
        } else if (attribute == this.period) {
            double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
            if (periodValue <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Period is required to be positive.  Period given: " + periodValue);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        DiscreteClock newObject = (DiscreteClock)((Object)super.clone(workspace));
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType((Typeable)newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        Time currentTime = this.getDirector().getModelTime();
        double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
        if (this._debugging) {
            this._debug("--- Firing at time " + currentTime + ".");
        }
        this._updateTentativeValues();
        this._tentativeNextFiringTime = Time.NEGATIVE_INFINITY;
        this._tentativeCycleCountIncrement = 0;
        if (this._tentativeCycleCount > 0) {
            while (this._tentativeCycleStartTime.add(periodValue).compareTo((Object)currentTime) < 0) {
                this._tentativeCycleStartTime = this._tentativeCycleStartTime.add(periodValue);
            }
            Time currentPhaseTime = this._tentativeCycleStartTime.add(this._offsets[this._tentativePhase]);
            if (currentTime.compareTo((Object)currentPhaseTime) == 0) {
                Time stopTime;
                int cycleLimit;
                this._tentativeCurrentValue = this._getValue(this._tentativePhase);
                ++this._tentativePhase;
                if (this._tentativePhase >= this._offsets.length) {
                    this._tentativePhase = 0;
                    this._tentativeCycleStartTime = this._tentativeCycleStartTime.add(periodValue);
                    ++this._tentativeCycleCountIncrement;
                }
                if (this._offsets[this._tentativePhase] >= periodValue) {
                    throw new IllegalActionException((Nameable)this, "Offset number " + this._tentativePhase + " with value " + this._offsets[this._tentativePhase] + " must be strictly less than the " + "period, which is " + periodValue);
                }
                this._tentativeNextFiringTime = this._tentativeCycleStartTime.add(this._offsets[this._tentativePhase]);
                if (this._debugging) {
                    this._debug("next firing is at " + this._tentativeNextFiringTime);
                }
                if ((cycleLimit = ((IntToken)this.numberOfCycles.getToken()).intValue()) > 0 && currentTime.compareTo((Object)(stopTime = this._tentativeStartTime.add((double)cycleLimit * periodValue))) >= 0) {
                    this._tentativeCurrentValue = this._tentativeCurrentValue.zero();
                }
                this.output.send(0, this._tentativeCurrentValue);
                if (this._debugging) {
                    this._debug("Output: " + this._tentativeCurrentValue + ".");
                }
            }
        }
    }

    public void initialize() throws IllegalActionException {
        Time timeToStart;
        super.initialize();
        if (this._debugging) {
            this._debug("Initializing " + this.getFullName() + ".");
        }
        this._cycleStartTime = timeToStart = this.getDirector().getModelTime();
        this._startTime = timeToStart.add(this._offsets[0]);
        this._currentValue = this._getValue(0).zero();
        this._phase = 0;
        this._tentativeNextFiringTime = this._startTime;
        this._initializeCycleCount();
        if (!this._done) {
            if (this._debugging) {
                this._debug("Requesting firing at time " + this._startTime);
            }
            this.getDirector().fireAt((Actor)this, this._tentativeNextFiringTime);
        }
    }

    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Postfiring at " + this.getDirector().getModelTime());
        }
        this._updateStates();
        return super.postfire();
    }

    public boolean prefire() throws IllegalActionException {
        ArrayToken val = (ArrayToken)this.values.getToken();
        if (this._offsets.length != val.length()) {
            throw new IllegalActionException((Nameable)this, "Values and offsets vectors do not have the same length.");
        }
        return super.prefire();
    }

    protected Token _getValue(int index) throws IllegalActionException {
        ArrayToken val = (ArrayToken)this.values.getToken();
        if (val == null || val.length() <= index) {
            throw new IllegalActionException((Nameable)this, "Index out of range of the values parameter.");
        }
        return val.getElement(index);
    }

    protected void _initializeCycleCount() {
        this._done = false;
        this._cycleCount = 1;
    }

    protected void _updateTentativeValues() throws IllegalActionException {
        this._tentativeCurrentValue = this._currentValue;
        this._tentativeCycleCount = this._cycleCount;
        this._tentativeCycleStartTime = this._cycleStartTime;
        this._tentativeDone = this._done;
        this._tentativePhase = this._phase;
        this._tentativeStartTime = this._startTime;
    }

    protected void _updateStates() throws IllegalActionException {
        this._cycleStartTime = this._tentativeCycleStartTime;
        this._currentValue = this._tentativeCurrentValue;
        this._phase = this._tentativePhase;
        this._cycleCount = this._tentativeCycleCount;
        this._startTime = this._tentativeStartTime;
        this._done = this._tentativeDone;
        this._cycleCount += this._tentativeCycleCountIncrement;
        if (this._debugging) {
            this._debug("Phase for next iteration: " + this._phase);
        }
        int cycleLimit = ((IntToken)this.numberOfCycles.getToken()).intValue();
        if (!this._done && this._tentativeNextFiringTime.compareTo((Object)Time.NEGATIVE_INFINITY) != 0) {
            this.getDirector().fireAt((Actor)this, this._tentativeNextFiringTime);
            if (this._debugging) {
                this._debug("Requesting firing at: " + this._tentativeNextFiringTime + ".");
            }
        }
        boolean bl = this._done = this._done || cycleLimit > 0 && this._cycleCount > cycleLimit && this._phase == 0;
        if (this._done) {
            this._cycleCount = 0;
            if (this._debugging) {
                this._debug("Done with requested number of cycles.");
            }
        }
        if (this._debugging) {
            this._debug("Cycle count for next iteration: " + this._cycleCount + ".");
        }
    }
}

