/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class CTRateLimiter
extends Transformer {
    public Parameter risingSlewRate;
    public Parameter fallingSlewRate;
    private Time _lastTime;
    private Token _lastToken;
    private Token _newToken;

    public CTRateLimiter(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.DOUBLE);
        this.output.setTypeEquals((Type)BaseType.DOUBLE);
        this.risingSlewRate = new Parameter((NamedObj)this, "risingSlewRate", (Token)new DoubleToken(1.0));
        this.fallingSlewRate = new Parameter((NamedObj)this, "fallingSlewRate", (Token)new DoubleToken(-1.0));
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            this._newToken = this.input.get(0);
            Time currentTime = this.getDirector().getModelTime();
            if (currentTime.compareTo((Object)this._lastTime) == 0) {
                if (this._lastToken != null) {
                    this._newToken = this._lastToken;
                }
                this.output.send(0, this._newToken);
            } else {
                double valueDifference = ((DoubleToken)this._newToken.subtract(this._lastToken)).doubleValue();
                double timeDifference = currentTime.subtract(this._lastTime).getDoubleValue();
                double rate = valueDifference / timeDifference;
                double risingRate = ((DoubleToken)this.risingSlewRate.getToken()).doubleValue();
                double fallingRate = ((DoubleToken)this.fallingSlewRate.getToken()).doubleValue();
                if (rate > risingRate) {
                    this._newToken = new DoubleToken(timeDifference * risingRate).add(this._lastToken);
                } else if (rate < fallingRate) {
                    this._newToken = new DoubleToken(timeDifference * fallingRate).add(this._lastToken);
                }
                this.output.send(0, this._newToken);
            }
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._lastTime = new Time(this.getDirector());
        this._lastToken = null;
    }

    public boolean postfire() throws IllegalActionException {
        this._lastTime = this.getDirector().getModelTime();
        this._lastToken = this._newToken;
        return super.postfire();
    }
}

