/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel.solver;

import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.domains.ct.kernel.CTBaseIntegrator;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.ODESolver;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Workspace;

public class TrapezoidalRuleSolver
extends ODESolver {
    private static final String _DEFAULT_NAME = "CT_Trapezoidal_Rule_Solver";
    private boolean _recalculatingWithTwoSteps = false;
    private boolean _firstStep = true;

    public TrapezoidalRuleSolver() {
        this(null);
    }

    public TrapezoidalRuleSolver(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_DEFAULT_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public void fireDynamicActors() throws IllegalActionException {
        this._setConverged(true);
        CTDirector director = (CTDirector)this.getContainer();
        super.fireDynamicActors();
        if (this._getRoundCount() == 0) {
            this._recalculatingWithTwoSteps = false;
            this._firstStep = true;
            director.setModelTime(director.getModelTime().add(director.getCurrentStepSize()));
        }
        if (this._isConverged()) {
            if (!this._recalculatingWithTwoSteps) {
                this._setConverged(false);
                this._recalculatingWithTwoSteps = true;
            } else if (this._firstStep) {
                this._setConverged(false);
                this._firstStep = false;
            }
        }
    }

    public void fireStateTransitionActors() throws IllegalActionException {
        super.fireStateTransitionActors();
        this._incrementRoundCount();
        if (this._isConverged()) {
            this._resetRoundCount();
        }
    }

    public int getAmountOfHistoryInformation() {
        return 0;
    }

    public int getIntegratorAuxVariableCount() {
        return 2;
    }

    public void integratorFire(CTBaseIntegrator integrator) throws IllegalActionException {
        double tentativeState;
        CTDirector director = (CTDirector)this.getContainer();
        double h = director.getCurrentStepSize();
        if (this._getRoundCount() == 0) {
            double f1 = integrator.getDerivative();
            tentativeState = integrator.getState() + f1 * h;
            this._voteForConverged(false);
        } else {
            double f1 = integrator.getDerivative();
            double f2 = ((DoubleToken)integrator.input.get(0)).doubleValue();
            if (!this._recalculatingWithTwoSteps) {
                tentativeState = integrator.getState() + h * (f1 + f2) / 2.0;
                double error = Math.abs(tentativeState - integrator.getTentativeState());
                if (error < director.getValueResolution()) {
                    integrator.setAuxVariables(0, tentativeState);
                    this._voteForConverged(true);
                } else {
                    this._voteForConverged(false);
                }
            } else {
                if (this._firstStep) {
                    tentativeState = integrator.getState() + h * (f1 + f2) / 2.0 / 2.0;
                } else {
                    double temp = tentativeState = integrator.getTentativeState() + h * (f1 + f2) / 2.0 / 2.0;
                    integrator.setAuxVariables(0, temp);
                    tentativeState = integrator.getAuxVariables()[0];
                    integrator.setTentativeDerivative(f2);
                }
                this._voteForConverged(true);
            }
        }
        integrator.setTentativeState(tentativeState);
        integrator.output.broadcast((Token)new DoubleToken(tentativeState));
    }

    public boolean integratorIsAccurate(CTBaseIntegrator integrator) {
        CTDirector director = (CTDirector)this.getContainer();
        double tolerance = director.getErrorTolerance();
        double[] k = integrator.getAuxVariables();
        double localError = 0.3333333333333333 * Math.abs(integrator.getTentativeState() - k[0]);
        integrator.setAuxVariables(1, localError);
        if (this._debugging) {
            this._debug("Integrator: " + integrator.getName() + " local truncation error = " + localError);
        }
        if (localError < tolerance) {
            if (this._debugging) {
                this._debug("Integrator: " + integrator.getName() + " report a success.");
            }
            return true;
        }
        if (this._debugging) {
            this._debug("Integrator: " + integrator.getName() + " reports a failure.");
        }
        return false;
    }

    public double integratorPredictedStepSize(CTBaseIntegrator integrator) {
        CTDirector director = (CTDirector)this.getContainer();
        double localError = integrator.getAuxVariables()[1];
        double h = director.getCurrentStepSize();
        double tolerance = director.getErrorTolerance();
        double newh = h;
        if (localError / tolerance < 0.1) {
            newh = h * Math.min(2.0, Math.pow(3.0 * tolerance / localError, 0.3333333333333333));
        }
        this._debug("integrator: " + integrator.getName() + " suggests next step size = " + newh);
        return newh;
    }

    public boolean resolveStates() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getContainer();
        if (this._getRoundCount() > director.getMaxIterations()) {
            this._resetRoundCount();
            return false;
        }
        return super.resolveStates();
    }
}

