/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel.solver;

import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.domains.ct.kernel.CTBaseIntegrator;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.solver.FixedStepSolver;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Workspace;

public class ForwardEulerSolver
extends FixedStepSolver {
    private static final String _DEFAULT_NAME = "CT_Forward_Euler_Solver";

    public ForwardEulerSolver() {
        this(null);
    }

    public ForwardEulerSolver(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_DEFAULT_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public void integratorFire(CTBaseIntegrator integrator) throws IllegalActionException {
        if (this._getRoundCount() == 0) {
            CTDirector director = (CTDirector)this.getContainer();
            double tentativeState = integrator.getState();
            double f = integrator.getDerivative();
            this._voteForConverged(false);
            integrator.setTentativeState(tentativeState += f * director.getCurrentStepSize());
            integrator.output.broadcast((Token)new DoubleToken(tentativeState));
        } else {
            double f = ((DoubleToken)integrator.input.get(0)).doubleValue();
            integrator.setTentativeDerivative(f);
        }
    }
}

