/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel.solver;

import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.domains.ct.kernel.CTBaseIntegrator;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.ODESolver;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ExplicitRK23Solver
extends ODESolver {
    private static final String _DEFAULT_NAME = "CT_Runge_Kutta_2_3_Solver";
    private static final double[] _timeInc = new double[]{0.5, 0.75, 1.0};
    private static final double[][] _B = new double[][]{{0.5}, {0.0, 0.75}, {0.2222222222222222, 0.3333333333333333, 0.4444444444444444}};
    private static final double[] _E = new double[]{-0.06944444444444445, 0.08333333333333333, 0.1111111111111111, -0.125};
    private static final int _order = 3;

    public ExplicitRK23Solver() {
        this(null);
    }

    public ExplicitRK23Solver(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_DEFAULT_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public void fireStateTransitionActors() throws IllegalActionException {
        super.fireStateTransitionActors();
        this._incrementRoundCount();
        if (this._getRoundCount() == _timeInc.length) {
            this._resetRoundCount();
            this._setConverged(true);
        }
    }

    public final int getAmountOfHistoryInformation() {
        return 0;
    }

    public final int getIntegratorAuxVariableCount() {
        return 4;
    }

    public void integratorFire(CTBaseIntegrator integrator) throws IllegalActionException {
        double outvalue;
        CTDirector director = (CTDirector)this.getContainer();
        int r = this._getRoundCount();
        double xn = integrator.getState();
        double h = director.getCurrentStepSize();
        double[] k = integrator.getAuxVariables();
        switch (r) {
            case 0: {
                double k0 = integrator.getDerivative();
                integrator.setAuxVariables(0, k0);
                outvalue = xn + h * k0 * _B[0][0];
                break;
            }
            case 1: {
                double k1 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(1, k1);
                outvalue = xn + h * (k[0] * _B[1][0] + k1 * _B[1][1]);
                break;
            }
            case 2: {
                double k2 = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setAuxVariables(2, k2);
                outvalue = xn + h * (k[0] * _B[2][0] + k[1] * _B[2][1] + k2 * _B[2][2]);
                integrator.setTentativeState(outvalue);
                break;
            }
            default: {
                throw new InvalidStateException((Nameable)this, "execution sequence out of range.");
            }
        }
        integrator.output.broadcast((Token)new DoubleToken(outvalue));
    }

    public boolean integratorIsAccurate(CTBaseIntegrator integrator) {
        block3: {
            try {
                CTDirector director = (CTDirector)this.getContainer();
                double tolerance = director.getErrorTolerance();
                double h = director.getCurrentStepSize();
                double f = ((DoubleToken)integrator.input.get(0)).doubleValue();
                integrator.setTentativeDerivative(f);
                double[] k = integrator.getAuxVariables();
                double error = h * Math.abs(k[0] * _E[0] + k[1] * _E[1] + k[2] * _E[2] + f * _E[3]);
                integrator.setAuxVariables(3, error);
                this._debug("Integrator: " + integrator.getName() + " local truncation error = " + error);
                if (!(error < tolerance)) break block3;
                this._debug("Integrator: " + integrator.getName() + " report a success.");
                return true;
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(String.valueOf(integrator.getName()) + " can't read input." + e.getMessage());
            }
        }
        this._debug("Integrator: " + integrator.getName() + " reports a failure.");
        return false;
    }

    public double integratorPredictedStepSize(CTBaseIntegrator integrator) {
        CTDirector director = (CTDirector)this.getContainer();
        double error = integrator.getAuxVariables()[3];
        double h = director.getCurrentStepSize();
        double tolerance = director.getErrorTolerance();
        double newh = 5.0 * h;
        if (error > director.getValueResolution()) {
            newh = h * Math.max(0.5, 0.8 * Math.pow(tolerance / error, 0.3333333333333333));
        }
        this._debug("integrator: " + integrator.getName() + " suggests next step size = " + newh);
        return newh;
    }

    protected void _advanceModelTime() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getContainer();
        Time iterationBeginTime = director.getIterationBeginTime();
        double currentStepSize = director.getCurrentStepSize();
        director.setModelTime(iterationBeginTime.add(currentStepSize * _timeInc[this._getRoundCount()]));
    }
}

