/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel.solver;

import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.domains.ct.kernel.CTBaseIntegrator;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.solver.FixedStepSolver;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Workspace;

public class BackwardEulerSolver
extends FixedStepSolver {
    private static final String _DEFAULT_NAME = "CT_Backward_Euler_Solver";

    public BackwardEulerSolver() {
        this(null);
    }

    public BackwardEulerSolver(Workspace workspace) {
        super(workspace);
        try {
            this.setName(_DEFAULT_NAME);
        }
        catch (KernelException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public void integratorFire(CTBaseIntegrator integrator) throws IllegalActionException {
        CTDirector director = (CTDirector)this.getContainer();
        double tentativeState = integrator.getState();
        if (this._getRoundCount() == 0) {
            double f = integrator.getDerivative();
            tentativeState += f * director.getCurrentStepSize();
            this._voteForConverged(false);
        } else {
            double f = ((DoubleToken)integrator.input.get(0)).doubleValue();
            double error = Math.abs((tentativeState += f * director.getCurrentStepSize()) - integrator.getTentativeState());
            if (error < director.getValueResolution()) {
                integrator.setTentativeDerivative(f);
            } else {
                this._voteForConverged(false);
            }
        }
        integrator.setTentativeState(tentativeState);
        integrator.output.broadcast((Token)new DoubleToken(tentativeState));
    }

    public boolean resolveStates() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getContainer();
        if (this._getRoundCount() > director.getMaxIterations()) {
            this._resetRoundCount();
            return false;
        }
        return super.resolveStates();
    }
}

