/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.xslt;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.XMLToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class XSLTransformer
extends Transformer {
    public FileParameter styleSheetFile;
    public PortParameter styleSheetParameters;
    private Source _xsltSource;
    private TransformerFactory _transformerFactory;
    private javax.xml.transform.Transformer _transformer;

    public XSLTransformer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.XMLTOKEN);
        this.output.setTypeEquals((Type)BaseType.STRING);
        this.styleSheetParameters = new PortParameter((NamedObj)this, "styleSheetParameters");
        this.styleSheetParameters.setTypeAtMost((Type)new RecordType(new String[0], new Type[0]));
        this.styleSheetParameters.setExpression("emptyRecord()");
        this.styleSheetFile = new FileParameter((NamedObj)this, "styleSheetFile");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        XSLTransformer newObject = (XSLTransformer)((Object)super.clone(workspace));
        newObject.input.setTypeEquals((Type)BaseType.XMLTOKEN);
        newObject.output.setTypeEquals((Type)BaseType.STRING);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.styleSheetParameters.update();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        if (this._debugging) {
            this._debug("--- open an output stream for the result. \n");
        }
        if (this._transformer != null) {
            RecordToken parameters = (RecordToken)this.styleSheetParameters.getToken();
            if (parameters != null) {
                for (String name : parameters.labelSet()) {
                    Token token = parameters.get(name);
                    if (token instanceof StringToken) {
                        StringToken s = (StringToken)token;
                        this._transformer.setParameter(name, s.stringValue());
                        continue;
                    }
                    this._transformer.setParameter(name, token.toString());
                }
            }
            int i = 0;
            while (i < this.input.getWidth()) {
                if (this.input.hasToken(i)) {
                    XMLToken in = (XMLToken)this.input.get(i);
                    Document doc = in.getDomTree();
                    try {
                        DOMSource xmlSource = new DOMSource(doc);
                        this._transformer.transform(xmlSource, result);
                        if (this._debugging) {
                            this._debug("--- transform the xmlSource: " + in.toString() + "\n");
                        }
                        if (out != null) {
                            if (this._debugging) {
                                this._debug("--- moml change request string: " + out.toString() + "\n");
                            }
                            StringToken outputToken = new StringToken(out.toString());
                            this.output.broadcast((Token)outputToken);
                            if (this._debugging) {
                                this._debug("--- change request string token send out. \n");
                            }
                        }
                    }
                    catch (TransformerException ex) {
                        throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed  to process '" + in + "'");
                    }
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed  to close or flush '" + out + "'");
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.input.getWidth()) {
                if (this.input.hasToken(i)) {
                    XMLToken in = (XMLToken)this.input.get(i);
                    this.output.broadcast((Token)new StringToken(in.toString()));
                }
                ++i;
            }
        }
    }

    public void initialize() throws IllegalActionException {
        this._xsltSource = null;
        this._transformer = null;
        try {
            BufferedReader reader = this.styleSheetFile.getExpression().trim().equals("") ? null : this.styleSheetFile.openForReading();
            this._xsltSource = reader != null ? new StreamSource(reader) : null;
            if (this._debugging) {
                this._debug("processing xsltSource change in " + this.getFullName());
            }
            if (this._xsltSource != null) {
                this._transformerFactory = TransformerFactory.newInstance();
                this._transformer = this._transformerFactory.newTransformer(this._xsltSource);
                if (this._debugging) {
                    this._debug("1 processing xsltSource change in " + this.getFullName());
                }
            } else {
                this._transformer = null;
            }
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Failed to initialize.");
        }
    }
}

