/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class StringReplace
extends TypedAtomicActor {
    public PortParameter stringToEdit;
    public TypedIOPort output;
    public PortParameter pattern = new PortParameter((NamedObj)this, "pattern");
    public Parameter replaceAll;
    public PortParameter replacement;
    private Pattern _pattern;

    public StringReplace(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.pattern.setStringMode(true);
        this.pattern.setExpression("");
        new SingletonParameter((NamedObj)this.pattern.getPort(), "_showName").setToken((Token)BooleanToken.TRUE);
        this.replaceAll = new Parameter((NamedObj)this, "replaceAll");
        this.replaceAll.setExpression("true");
        this.replaceAll.setTypeEquals((Type)BaseType.BOOLEAN);
        this.replacement = new PortParameter((NamedObj)this, "replacement");
        this.replacement.setStringMode(true);
        this.replacement.setExpression("");
        new SingletonParameter((NamedObj)this.replacement.getPort(), "_showName").setToken((Token)BooleanToken.TRUE);
        this.stringToEdit = new PortParameter((NamedObj)this, "stringToEdit");
        this.stringToEdit.setStringMode(true);
        this.stringToEdit.setExpression("");
        new SingletonParameter((NamedObj)this.stringToEdit.getPort(), "_showName").setToken((Token)BooleanToken.TRUE);
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setTypeEquals((Type)BaseType.STRING);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.pattern) {
            try {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                this._pattern = Pattern.compile(patternValue);
            }
            catch (PatternSyntaxException ex) {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to compile regular expression \"" + patternValue + "\"");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.replacement.update();
        this.stringToEdit.update();
        this.pattern.update();
        String replacementValue = ((StringToken)this.replacement.getToken()).stringValue();
        String stringToEditValue = ((StringToken)this.stringToEdit.getToken()).stringValue();
        boolean replaceAllTokens = ((BooleanToken)this.replaceAll.getToken()).booleanValue();
        Matcher match = this._pattern.matcher(stringToEditValue);
        String outputString = replaceAllTokens ? match.replaceAll(replacementValue) : match.replaceFirst(replacementValue);
        this.output.send(0, (Token)new StringToken(outputString));
    }
}

