/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.logic;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;

public class LogicFunction
extends Transformer {
    public StringAttribute function = new StringAttribute((NamedObj)this, "function");
    protected int _function;
    protected boolean _negate;
    protected static final int _AND = 0;
    protected static final int _OR = 1;
    protected static final int _XOR = 2;

    public LogicFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function.setExpression("and");
        this._function = 0;
        this._negate = false;
        this.input.setMultiport(true);
        this.output.setMultiport(false);
        this.input.setTypeEquals((Type)BaseType.BOOLEAN);
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"60\" height=\"30\" style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.function) {
            String functionName = this.function.getExpression().trim().toLowerCase();
            if (functionName.equals("and")) {
                this._function = 0;
                this._negate = false;
                return;
            } else if (functionName.equals("or")) {
                this._function = 1;
                this._negate = false;
                return;
            } else if (functionName.equals("xor")) {
                this._function = 2;
                this._negate = false;
                return;
            } else if (functionName.equals("nand")) {
                this._function = 0;
                this._negate = true;
                return;
            } else if (functionName.equals("nor")) {
                this._function = 1;
                this._negate = true;
                return;
            } else {
                if (!functionName.equals("xnor")) throw new IllegalActionException((Nameable)this, "Unrecognized logic function: " + functionName + ".  Valid functions are 'and', 'or', 'xor', " + "'nand', 'nor', and 'xnor'.");
                this._function = 2;
                this._negate = true;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        BooleanToken value = null;
        BooleanToken in = null;
        int i = 0;
        while (i < this.input.getWidth()) {
            if (this.input.hasToken(i) && (in = (BooleanToken)this.input.get(i)) != null) {
                value = this._updateFunction(in, value);
            }
            ++i;
        }
        if (value != null) {
            if (this._negate) {
                value = value.not();
            }
            this.output.send(0, (Token)value);
        }
    }

    protected BooleanToken _updateFunction(BooleanToken in, BooleanToken old) throws IllegalActionException {
        BooleanToken result;
        if (old == null) {
            result = in;
        } else {
            switch (this._function) {
                case 0: {
                    result = old.and(in);
                    break;
                }
                case 1: {
                    result = old.or(in);
                    break;
                }
                case 2: {
                    result = old.xor(in);
                    break;
                }
                default: {
                    throw new InternalErrorException("Invalid value for _function private variable. LogicFunction actor (" + this.getFullName() + ")" + " on function type " + this._function);
                }
            }
        }
        return result;
    }
}

