/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.io;

import java.io.File;
import java.io.PrintWriter;
import ptolemy.actor.lib.Sink;
import ptolemy.actor.parameters.FilePortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.MessageHandler;

public class LineWriter
extends Sink {
    public Parameter append;
    public FilePortParameter fileName;
    public Parameter confirmOverwrite;
    protected PrintWriter _writer;
    private String _previousFileName;

    public LineWriter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.STRING);
        this.input.setMultiport(false);
        this.fileName = new FilePortParameter((NamedObj)this, "fileName");
        this.fileName.setExpression("System.out");
        this.append = new Parameter((NamedObj)this, "append");
        this.append.setTypeEquals((Type)BaseType.BOOLEAN);
        this.append.setToken((Token)BooleanToken.FALSE);
        this.confirmOverwrite = new Parameter((NamedObj)this, "confirmOverwrite");
        this.confirmOverwrite.setTypeEquals((Type)BaseType.BOOLEAN);
        this.confirmOverwrite.setToken((Token)BooleanToken.TRUE);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-25\" y=\"-20\" width=\"50\" height=\"40\" style=\"fill:white\"/>\n<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10 15,-10 15,10, -15,10\" style=\"fill:red\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileName) {
            String newFileName = ((StringToken)this.fileName.getToken()).stringValue();
            if (this._previousFileName != null && !newFileName.equals(this._previousFileName)) {
                this._previousFileName = newFileName;
                this.fileName.close();
                this._writer = null;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LineWriter newObject = (LineWriter)((Object)super.clone(workspace));
        newObject._writer = null;
        return newObject;
    }

    public boolean postfire() throws IllegalActionException {
        this.fileName.update();
        if (this.input.hasToken(0)) {
            Token token = this.input.get(0);
            if (this._writer == null) {
                boolean appendValue = ((BooleanToken)this.append.getToken()).booleanValue();
                if (!this.fileName.stringValue().equals("System.out")) {
                    File file = this.fileName.asFile();
                    boolean confirmOverwriteValue = ((BooleanToken)this.confirmOverwrite.getToken()).booleanValue();
                    if (file.exists() && !appendValue && confirmOverwriteValue && !MessageHandler.yesNoQuestion((String)("OK to overwrite " + file + "?"))) {
                        throw new IllegalActionException((Nameable)this, "Please select another file name.");
                    }
                }
                this._writer = new PrintWriter(this.fileName.openForWriting(appendValue), true);
            }
            this._writeToken(token);
        }
        return super.postfire();
    }

    public void wrapup() throws IllegalActionException {
        this.fileName.close();
        this._writer = null;
    }

    protected void _writeToken(Token token) {
        this._writer.println(((StringToken)token).stringValue());
    }
}

