/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ptolemy.actor.lib.SequenceSource;
import ptolemy.actor.parameters.FilePortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class DirectoryListing
extends SequenceSource
implements FilenameFilter {
    public FilePortParameter directoryOrURL = new FilePortParameter((NamedObj)this, "directoryOrURL");
    public Parameter listOnlyDirectories;
    public Parameter listOnlyFiles;
    public StringParameter pattern;
    private Pattern _pattern;

    public DirectoryListing(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        new Parameter((NamedObj)this.directoryOrURL, "allowFiles", (Token)BooleanToken.FALSE);
        new Parameter((NamedObj)this.directoryOrURL, "allowDirectories", (Token)BooleanToken.TRUE);
        this.output.setTypeEquals((Type)new ArrayType((Type)BaseType.STRING));
        this.pattern = new StringParameter((NamedObj)this, "pattern");
        this.pattern.setExpression("");
        this.listOnlyDirectories = new Parameter((NamedObj)this, "listOnlyDirectories");
        this.listOnlyDirectories.setTypeEquals((Type)BaseType.BOOLEAN);
        this.listOnlyDirectories.setExpression("false");
        this.listOnlyFiles = new Parameter((NamedObj)this, "listOnlyFiles");
        this.listOnlyFiles.setTypeEquals((Type)BaseType.BOOLEAN);
        this.listOnlyFiles.setExpression("false");
    }

    public boolean accept(File directory, String name) {
        if (this._pattern != null) {
            Matcher match = this._pattern.matcher(name);
            return match.find();
        }
        return true;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.pattern) {
            try {
                this._pattern = Pattern.compile(this.pattern.stringValue());
            }
            catch (PatternSyntaxException ex) {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to compile regular expression \"" + patternValue + "\"");
            }
        }
        super.attributeChanged(attribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fire() throws IllegalActionException {
        super.fire();
        this.directoryOrURL.update();
        URL sourceURL = this.directoryOrURL.asURL();
        if (sourceURL == null) {
            throw new IllegalActionException((Nameable)this, "directoryOrURL is empty.");
        }
        boolean directoriesOnly = ((BooleanToken)this.listOnlyDirectories.getToken()).booleanValue();
        boolean filesOnly = ((BooleanToken)this.listOnlyFiles.getToken()).booleanValue();
        if (sourceURL.getProtocol().equals("file")) {
            File sourceFile = this.directoryOrURL.asFile();
            if (sourceFile.isDirectory()) {
                if (this._debugging) {
                    this._debug("Reading directory.");
                }
                File[] files = sourceFile.listFiles(this);
                ArrayList<StringToken> result = new ArrayList<StringToken>();
                int i = 0;
                while (i < files.length) {
                    if (!(filesOnly && !files[i].isFile() || directoriesOnly && !files[i].isDirectory() || !this.accept(null, files[i].getName()))) {
                        String path = files[i].getAbsolutePath();
                        if (this._debugging) {
                            this._debug("Path: " + path);
                        }
                        result.add(new StringToken(path));
                    }
                    ++i;
                }
                if (result.size() == 0) {
                    throw new IllegalActionException((Nameable)this, "No files or directories that match the pattern.");
                }
                StringToken[] resultArray = new StringToken[result.size()];
                int i2 = 0;
                while (i2 < resultArray.length) {
                    resultArray[i2] = (StringToken)result.get(i2);
                    ++i2;
                }
                this.output.broadcast((Token)new ArrayToken((Type)BaseType.STRING, (Token[])resultArray));
                return;
            } else {
                if (!sourceFile.isFile()) throw new IllegalActionException("'" + this.directoryOrURL + "' is neither a file " + "nor a directory.");
                StringToken[] result = new StringToken[]{new StringToken(sourceFile.toString())};
                if (this._debugging) {
                    this._debug("Listing just the specified file: " + result[0].stringValue());
                }
                this.output.broadcast((Token)new ArrayToken((Type)BaseType.STRING, (Token[])result));
            }
            return;
        }
        try {
            this._readURL(sourceURL);
            return;
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, (Throwable)ex, "Error reading the URL '" + this.directoryOrURL + "'.");
        }
    }

    private void _readURL(URL sourceURL) throws IOException, IllegalActionException {
        Object results;
        URLConnection urlConnection;
        String contentType;
        if (this._debugging) {
            this._debug("Reading URL: " + sourceURL);
        }
        if (!(contentType = (urlConnection = sourceURL.openConnection()).getContentType()).startsWith("text/html") && !contentType.startsWith("text/plain")) {
            throw new IllegalActionException((Nameable)this, "Could not parse '" + this.directoryOrURL.stringValue() + "'; it is not \"text/html\", " + "or \"text/plain\", it is: " + urlConnection.getContentType());
        }
        LinkedList<StringToken> resultsList = new LinkedList<StringToken>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            if (!contentType.startsWith("text/plain") && !urlConnection.getURL().toString().endsWith("/")) {
                throw new IllegalActionException((Nameable)this, "Could not parse '" + this.directoryOrURL.stringValue() + "'; it needs to end with '/'");
            }
            String target = null;
            boolean sawBody = false;
            boolean sawHREF = false;
            while ((line = in.readLine()) != null) {
                line = line.trim();
                if (this._debugging) {
                    this._debug(line);
                }
                if (line.startsWith("<BODY") || line.startsWith("<body")) {
                    sawBody = true;
                    continue;
                }
                if (!sawBody) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, "<\" >=");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.compareToIgnoreCase("HREF") == 0) {
                        sawHREF = true;
                        target = null;
                        continue;
                    }
                    if (!sawHREF) continue;
                    if (target == null) {
                        target = token;
                        continue;
                    }
                    String reference = target;
                    if (reference.length() > 20) {
                        reference = target.substring(0, 20);
                    }
                    if (!token.startsWith(reference)) {
                        sawHREF = false;
                        continue;
                    }
                    if (this.accept(null, target)) {
                        String base = this.directoryOrURL.stringValue();
                        if (!base.endsWith("/")) {
                            base = String.valueOf(base) + "/";
                        }
                        resultsList.add(new StringToken(String.valueOf(base) + target));
                    }
                    sawHREF = false;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (this._debugging) {
            this._debug("----- end of listing.");
            this._debug("----- extracted results:");
            results = resultsList.iterator();
            while (results.hasNext()) {
                this._debug(((StringToken)results.next()).stringValue());
            }
        }
        results = new StringToken[resultsList.size()];
        this.output.broadcast((Token)new ArrayToken((Type)BaseType.STRING, (Token[])((StringToken[])resultsList.toArray((T[])results))));
    }
}

