/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.hoc.MultiCompositeActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class RefinementPort
extends TypedIOPort {
    protected boolean _automaticallyInput = false;
    protected boolean _mirrorDisable = false;

    public RefinementPort(Workspace workspace) {
        super(workspace);
        this._checkWhetherMirrorIsInput();
    }

    public RefinementPort(ComponentEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._checkWhetherMirrorIsInput();
    }

    public boolean isTypeAcceptable() {
        if (this.numInsideLinks() == 0) {
            return true;
        }
        return super.isTypeAcceptable();
    }

    public void link(Relation relation) throws IllegalActionException {
        super.link(relation);
        if (this.isMultiport()) {
            ((IORelation)relation).setWidth(0);
        }
    }

    public int moveDown() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveDown();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveDown();
                    success = true;
                }
                if (!success) {
                    result = super.moveDown();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveToFirst() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveToFirst();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveToFirst();
                    success = true;
                }
                if (!success) {
                    result = super.moveToFirst();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveToIndex(int index) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveToIndex(index);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveToIndex(index);
                    success = true;
                }
                if (!success) {
                    result = super.moveToIndex(index);
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveToLast() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveToLast();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveToLast();
                    success = true;
                }
                if (!success) {
                    result = super.moveToLast();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveUp() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveUp();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveUp();
                    success = true;
                }
                if (!success) {
                    result = super.moveUp();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setContainer(Entity container) throws IllegalActionException, NameDuplicationException {
        NamedObj oldContainer = this.getContainer();
        if (container == oldContainer) {
            return;
        }
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                super.setContainer(container);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                if (oldContainer != null && (modal = oldContainer.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) != null) {
                    port.setContainer(null);
                    success = true;
                }
                if (!success) {
                    super.setContainer(container);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setInput(boolean isInput) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null || this._automaticallyInput) {
                super.setInput(isInput);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).setInput(isInput);
                    success = true;
                }
                if (!success) {
                    super.setInput(isInput);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setMirrorDisable(boolean disable) {
        this._mirrorDisable = disable;
    }

    public void setMultiport(boolean isMultiport) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                super.setMultiport(isMultiport);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).setMultiport(isMultiport);
                    success = true;
                }
                if (!success) {
                    super.setMultiport(isMultiport);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                super.setName(name);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) != null) {
                    port.setName(name);
                    success = true;
                }
                if (!success) {
                    super.setName(name);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setOutput(boolean isOutput) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                super.setOutput(isOutput);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).setOutput(isOutput);
                    success = true;
                }
                if (!success) {
                    super.setOutput(isOutput);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    private void _checkWhetherMirrorIsInput() {
        Port port;
        NamedObj modal;
        NamedObj container = this.getContainer();
        if (container != null && (modal = container.getContainer()) instanceof MultiCompositeActor && (port = ((MultiCompositeActor)modal).getPort(this.getName())) instanceof IOPort && !((IOPort)port).isInput() && ((IOPort)port).isOutput()) {
            this._automaticallyInput = true;
        }
    }
}

