/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.net.URL;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLParser;

public class ModelUtilities {
    private ModelUtilities() {
    }

    public static synchronized RecordToken executeModel(URL url, RecordToken args, String[] resultLabels) throws IllegalActionException {
        if (url != null) {
            NamedObj model;
            MoMLParser parser = new MoMLParser();
            try {
                model = parser.parse(null, url);
            }
            catch (Exception ex) {
                throw new IllegalActionException(ex + "Failed to pass the model URL." + url.toString());
            }
            if (model instanceof CompositeActor) {
                return ModelUtilities.executeModel((CompositeActor)model, args, resultLabels);
            }
            return null;
        }
        return null;
    }

    public static synchronized RecordToken executeModel(CompositeActor model, RecordToken args, String[] resultLabels) throws IllegalActionException {
        Manager manager = model.getManager();
        if (manager == null) {
            manager = new Manager(model.workspace(), "Manager");
            model.setManager(manager);
        }
        ModelUtilities._setAttribute(model, args);
        try {
            manager.execute();
        }
        catch (KernelException ex) {
            throw new IllegalActionException((Object)((Object)ex) + "Execution failed.");
        }
        return ModelUtilities._getResult(model, resultLabels);
    }

    private static void _setAttribute(CompositeActor model, RecordToken args) throws IllegalActionException {
        Object[] labels = args.labelSet().toArray();
        int length = args.length();
        int i = 0;
        while (i < length) {
            String label = (String)labels[i];
            Attribute attribute = model.getAttribute(label);
            if (attribute != null) {
                Token token = args.get(label);
                if (attribute instanceof Variable) {
                    ((Variable)attribute).setToken(token);
                } else if (attribute instanceof Settable) {
                    ((Settable)attribute).setExpression(token.toString());
                }
            }
            ++i;
        }
    }

    private static RecordToken _getResult(CompositeActor model, String[] resultLabels) throws IllegalActionException {
        Token[] value = new Token[resultLabels.length];
        int i = 0;
        while (i < resultLabels.length) {
            String label = resultLabels[i];
            Attribute attribute = model.getAttribute(label);
            if (attribute instanceof Variable) {
                value[i] = ((Variable)attribute).getToken();
            }
            ++i;
        }
        return new RecordToken(resultLabels, value);
    }
}

