/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.lib.hoc.MirrorPort;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.HandlesInternalLinks;

public class MirrorComposite
extends TypedCompositeActor
implements HandlesInternalLinks {
    private boolean _inAddPort = false;
    private boolean _inRemoveEntity = false;

    public MirrorComposite(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setClassName("ptolemy.actor.lib.hoc.MirrorComposite");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<text x=\"-6\" y=\"10\"style=\"font-size:24\">?</text>\n</svg>\n");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        MirrorComposite result = (MirrorComposite)((Object)super.clone(workspace));
        for (Entity insideEntity : result.entityList()) {
            for (MirrorPort port : result.portList()) {
                Port insidePort = insideEntity.getPort(port.getName());
                if (!(insidePort instanceof MirrorPort)) continue;
                port.setAssociatedPort((MirrorPort)insidePort);
            }
        }
        return result;
    }

    public Port newPort(String name) throws NameDuplicationException {
        try {
            MirrorPort result = new MirrorPort((ComponentEntity)this, name);
            return result;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException((Nameable)this, (Throwable)ex, null);
        }
    }

    protected void _addEntity(ComponentEntity entity) throws IllegalActionException, NameDuplicationException {
        if (entity.isClassDefinition()) {
            throw new IllegalActionException((Nameable)this, "Cannot place a class definition in an MirrorComposite actor.");
        }
        super._addEntity(entity);
        ChangeRequest request = new ChangeRequest((Object)this, "Adjust contained entities, ports and parameters"){

            public NamedObj getLocality() {
                return MirrorComposite.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void _execute() throws Exception {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        MirrorComposite.this.workspace().getWriteAccess();
                        ComponentEntity entity = null;
                        List priorEntities = MirrorComposite.this.entityList();
                        Iterator priors = priorEntities.iterator();
                        while (priors.hasNext()) {
                            ComponentEntity prior = (ComponentEntity)priors.next();
                            if (priors.hasNext()) {
                                prior.setContainer(null);
                                continue;
                            }
                            entity = prior;
                        }
                        if (entity == null) {
                            return;
                        }
                        for (ComponentPort insidePort : entity.portList()) {
                            List connectedPorts;
                            String name = insidePort.getName();
                            IOPort newPort = (IOPort)MirrorComposite.this.getPort(name);
                            if (newPort == null) {
                                newPort = (IOPort)MirrorComposite.this.newPort(name);
                            }
                            if (insidePort instanceof IOPort) {
                                IOPort castPort = (IOPort)insidePort;
                                newPort.setMultiport(castPort.isMultiport());
                                newPort.setInput(castPort.isInput());
                                newPort.setOutput(castPort.isOutput());
                            }
                            if ((connectedPorts = insidePort.connectedPortList()).contains(newPort)) continue;
                            ComponentRelation relation = MirrorComposite.this.newRelation(MirrorComposite.this.uniqueName("relation"));
                            newPort.link((Relation)relation);
                            insidePort.link((Relation)relation);
                        }
                    }
                    finally {
                        MirrorComposite.this.workspace().doneWriting();
                    }
                }
            }
        };
        this.requestChange(request);
    }

    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        if (!(port instanceof MirrorPort)) {
            throw new IllegalActionException((Nameable)this, "MirrorComposite ports are required to be instances of MirrorPort");
        }
        super._addPort(port);
        final MirrorPort castPort = (MirrorPort)port;
        ChangeRequest request = new ChangeRequest((Object)this, "Add a port on the inside"){

            public NamedObj getLocality() {
                return MirrorComposite.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void _execute() throws Exception {
                2 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        MirrorComposite.this.workspace().getWriteAccess();
                        MirrorComposite.this._inAddPort = true;
                        String portName = castPort.getName();
                        Iterator entities = MirrorComposite.this.entityList().iterator();
                        if (entities.hasNext()) {
                            List connectedPorts;
                            Entity insideEntity = (Entity)entities.next();
                            Port insidePort = insideEntity.getPort(portName);
                            if (insidePort == null && (insidePort = insideEntity.newPort(portName)) instanceof IOPort) {
                                IOPort castInsidePort = (IOPort)insidePort;
                                castInsidePort.setInput(castPort.isInput());
                                castInsidePort.setOutput(castPort.isOutput());
                                castInsidePort.setMultiport(castPort.isMultiport());
                            }
                            if (insidePort instanceof MirrorPort) {
                                castPort.setAssociatedPort((MirrorPort)insidePort);
                            }
                            if (!(connectedPorts = insidePort.connectedPortList()).contains((Object)castPort)) {
                                ComponentRelation newRelation = MirrorComposite.this.newRelation(MirrorComposite.this.uniqueName("relation"));
                                insidePort.link((Relation)newRelation);
                                castPort.link((Relation)newRelation);
                            }
                        }
                    }
                    finally {
                        MirrorComposite.this.workspace().doneWriting();
                        MirrorComposite.this._inAddPort = false;
                    }
                }
            }
        };
        this.requestChange(request);
    }

    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        for (Attribute attribute : this.attributeList()) {
            attribute.exportMoML(output, depth);
        }
        for (Port port : this.portList()) {
            port.exportMoML(output, depth);
        }
        for (ComponentEntity entity : this.entityList()) {
            entity.exportMoML(output, depth);
        }
    }

    protected void _removeEntity(ComponentEntity entity) {
        super._removeEntity(entity);
        Iterator relations = this.relationList().iterator();
        while (relations.hasNext()) {
            try {
                ((ComponentRelation)relations.next()).setContainer(null);
            }
            catch (KernelException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        for (Port port : new LinkedList(this.portList())) {
            try {
                try {
                    this._inRemoveEntity = true;
                    port.setContainer(null);
                }
                catch (KernelException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            finally {
                this._inRemoveEntity = false;
            }
        }
    }

    protected void _removePort(Port port) {
        super._removePort(port);
        for (ComponentRelation relation : ((IOPort)port).insideRelationList()) {
            try {
                relation.setContainer(null);
            }
            catch (KernelException ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
        if (this._inRemoveEntity) {
            return;
        }
        for (Entity insideEntity : this.entityList()) {
            Port insidePort = insideEntity.getPort(port.getName());
            if (insidePort == null) continue;
            try {
                insidePort.setContainer(null);
            }
            catch (KernelException ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
    }

    public static class MirrorCompositeContents
    extends TypedCompositeActor {
        public MirrorCompositeContents(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Port newPort(String name) throws NameDuplicationException {
            try {
                return new MirrorPort((ComponentEntity)this, name);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException((Nameable)this, (Throwable)ex, null);
            }
        }

        protected void _addPort(final Port port) throws IllegalActionException, NameDuplicationException {
            if (!(port instanceof MirrorPort)) {
                throw new IllegalActionException((Nameable)this, "Ports in MirrorComposiMirrorCompositeContentsite must be MirrorPort.");
            }
            super._addPort(port);
            final MirrorComposite container = (MirrorComposite)this.getContainer();
            if (container._inAddPort) {
                return;
            }
            ChangeRequest request = new ChangeRequest((Object)this, "Add mirror port to the container."){

                public NamedObj getLocality() {
                    return MirrorCompositeContents.this.getContainer();
                }

                protected void _execute() throws Exception {
                    try {
                        MirrorCompositeContents.this.workspace().getWriteAccess();
                        MirrorPort newPort = (MirrorPort)container.getPort(port.getName());
                        if (newPort == null) {
                            newPort = (MirrorPort)container.newPort(port.getName());
                        }
                        if (port instanceof IOPort) {
                            newPort.setInput(((IOPort)port).isInput());
                            newPort.setOutput(((IOPort)port).isOutput());
                            newPort.setMultiport(((IOPort)port).isMultiport());
                        }
                    }
                    finally {
                        MirrorCompositeContents.this.workspace().doneWriting();
                    }
                }
            };
            container.requestChange(request);
        }
    }
}

