/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.conversions.Converter;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class StringToUnsignedByteArray
extends Converter {
    public StringToUnsignedByteArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.STRING);
        this.output.setTypeEquals((Type)new ArrayType((Type)BaseType.UNSIGNED_BYTE));
    }

    public void fire() throws IllegalActionException {
        super.fire();
        String inputValue = ((StringToken)this.input.get(0)).stringValue();
        byte[] dataBytes = inputValue.getBytes();
        int bytesAvailable = dataBytes.length;
        Token[] dataTokens = new Token[bytesAvailable];
        int j = 0;
        while (j < bytesAvailable) {
            dataTokens[j] = new UnsignedByteToken(dataBytes[j]);
            ++j;
        }
        this.output.send(0, (Token)new ArrayToken((Type)BaseType.UNSIGNED_BYTE, dataTokens));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

