/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class StringToIntArray
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort((ComponentEntity)this, "input", true, false);
    public TypedIOPort output;

    public StringToIntArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.STRING);
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setTypeEquals((Type)new ArrayType((Type)BaseType.INT));
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        String inputValue = ((StringToken)this.input.get(0)).stringValue();
        byte[] dataBytes = inputValue.getBytes();
        int bytesAvailable = inputValue.length();
        Token[] dataIntTokens = new Token[bytesAvailable];
        int j = 0;
        while (j < bytesAvailable) {
            dataIntTokens[j] = new IntToken((int)dataBytes[j]);
            ++j;
        }
        this.output.send(0, (Token)new ArrayToken((Type)BaseType.INT, dataIntTokens));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

