/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.Complex;

public class ComplexToPolar
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort((ComponentEntity)this, "input", true, false);
    public TypedIOPort magnitude;
    public TypedIOPort angle;

    public ComplexToPolar(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.COMPLEX);
        this.magnitude = new TypedIOPort((ComponentEntity)this, "magnitude", false, true);
        this.magnitude.setTypeEquals((Type)BaseType.DOUBLE);
        this.angle = new TypedIOPort((ComponentEntity)this, "angle", false, true);
        this.angle.setTypeEquals((Type)BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        Complex inputValue = ((ComplexToken)this.input.get(0)).complexValue();
        double magnitudeValue = Math.sqrt(inputValue.real * inputValue.real + inputValue.imag * inputValue.imag);
        double angleValue = Math.atan2(inputValue.imag, inputValue.real);
        this.magnitude.send(0, (Token)new DoubleToken(magnitudeValue));
        this.angle.send(0, (Token)new DoubleToken(angleValue));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

