/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class CartesianToPolar
extends TypedAtomicActor {
    public TypedIOPort x = new TypedIOPort((ComponentEntity)this, "x", true, false);
    public TypedIOPort y;
    public TypedIOPort magnitude;
    public TypedIOPort angle;

    public CartesianToPolar(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.x.setTypeEquals((Type)BaseType.DOUBLE);
        this.y = new TypedIOPort((ComponentEntity)this, "y", true, false);
        this.y.setTypeEquals((Type)BaseType.DOUBLE);
        this.magnitude = new TypedIOPort((ComponentEntity)this, "magnitude", false, true);
        this.magnitude.setTypeEquals((Type)BaseType.DOUBLE);
        this.angle = new TypedIOPort((ComponentEntity)this, "angle", false, true);
        this.angle.setTypeEquals((Type)BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        double xValue = ((DoubleToken)this.x.get(0)).doubleValue();
        double yValue = ((DoubleToken)this.y.get(0)).doubleValue();
        double magnitudeValue = Math.sqrt(xValue * xValue + yValue * yValue);
        double angleValue = Math.atan2(yValue, xValue);
        this.magnitude.send(0, (Token)new DoubleToken(magnitudeValue));
        this.angle.send(0, (Token)new DoubleToken(angleValue));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.x.hasToken(0) || !this.y.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

