/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.comm.HuffmanBasic;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class HuffmanDecoder
extends HuffmanBasic {
    private String _code = "";

    public HuffmanDecoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType((Typeable)this.alphabet));
        this.input.setTypeEquals((Type)BaseType.BOOLEAN);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        HuffmanDecoder newObject = (HuffmanDecoder)((Object)super.clone(workspace));
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType((Typeable)newObject.alphabet));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken alphabetArrayToken = (ArrayToken)this.alphabet.getToken();
        Token[] alphabetTokens = new Token[this._pmf.length];
        int i = 0;
        while (i < this._pmf.length) {
            alphabetTokens[i] = alphabetArrayToken.getElement(i);
            ++i;
        }
        if (!this.input.hasToken(0) && !this._code.equals("")) {
            throw new IllegalActionException((Nameable)this, "This is not a decodable code.");
        }
        BooleanToken inputToken = (BooleanToken)this.input.get(0);
        this._code = inputToken.booleanValue() ? String.valueOf(this._code) + "1" : String.valueOf(this._code) + "0";
        int i2 = 0;
        while (i2 < this._pmf.length) {
            if (this._code.equals(this._codeBook[i2])) {
                this.output.send(0, alphabetTokens[i2]);
                this._code = "";
                break;
            }
            ++i2;
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._code = "";
    }
}

