/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.comm.HuffmanBasic;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class HuffmanCoder
extends HuffmanBasic {
    public HuffmanCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.alphabet.setTypeAtLeast(ArrayType.arrayOf((Typeable)this.input));
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        HuffmanCoder newObject = (HuffmanCoder)((Object)super.clone(workspace));
        try {
            newObject.alphabet.setTypeAtLeast(ArrayType.arrayOf((Typeable)newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken alphabetArrayToken = (ArrayToken)this.alphabet.getToken();
        Token[] alphabetTokens = new Token[this._pmf.length];
        int i = 0;
        while (i < this._pmf.length) {
            alphabetTokens[i] = alphabetArrayToken.getElement(i);
            ++i;
        }
        Token inputToken = this.input.get(0);
        int i2 = 0;
        while (i2 < this._pmf.length) {
            if (inputToken.equals(alphabetTokens[i2])) {
                this._sendBooleans(this._codeBook[i2]);
                break;
            }
            ++i2;
        }
    }

    private void _sendBooleans(String codeword) throws IllegalActionException {
        int i = 0;
        while (i < codeword.length()) {
            if (codeword.charAt(i) == '1') {
                this.output.send(0, (Token)new BooleanToken(true));
            } else {
                this.output.send(0, (Token)new BooleanToken(false));
            }
            ++i;
        }
    }
}

