/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import java.util.LinkedList;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class HuffmanBasic
extends Transformer {
    public Parameter pmf = new Parameter((NamedObj)this, "pmf");
    public Parameter alphabet;
    public TypedIOPort huffmanCodeBook;
    protected String[] _codeBook;
    protected boolean _parametersInvalid;
    protected double[] _pmf;

    public HuffmanBasic(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.pmf.setExpression("{0.5, 0.5}");
        this.pmf.setTypeEquals((Type)new ArrayType((Type)BaseType.DOUBLE));
        this.alphabet = new Parameter((NamedObj)this, "alphabet");
        this.alphabet.setExpression("{0, 1}");
        this.alphabet.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.huffmanCodeBook = new TypedIOPort((ComponentEntity)this, "huffmanCodeBook", false, true);
        this.huffmanCodeBook.setTypeEquals((Type)new ArrayType((Type)BaseType.STRING));
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        HuffmanBasic newObject = (HuffmanBasic)((Object)super.clone(workspace));
        newObject.alphabet.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        return newObject;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        this._parametersInvalid = true;
        if (attribute == this.pmf) {
            ArrayToken pmfValue = (ArrayToken)this.pmf.getToken();
            this._pmf = new double[pmfValue.length()];
            double sum = 0.0;
            int i = 0;
            while (i < this._pmf.length) {
                this._pmf[i] = ((DoubleToken)pmfValue.getElement(i)).doubleValue();
                if (this._pmf[i] <= 0.0) {
                    throw new IllegalActionException((Nameable)this, "Probabilities must be positive!");
                }
                sum += this._pmf[i];
                ++i;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken alphabetArrayToken = (ArrayToken)this.alphabet.getToken();
        if (this._pmf.length != alphabetArrayToken.length()) {
            throw new IllegalActionException((Nameable)this, "uncoded alphabet and pmf are required to be arrayswith same length.");
        }
        Token[] alphabetTokens = new Token[this._pmf.length];
        int i = 0;
        while (i < this._pmf.length) {
            alphabetTokens[i] = alphabetArrayToken.getElement(i);
            ++i;
        }
        if (this._parametersInvalid) {
            this._parametersInvalid = false;
            this._codeBook = this.generateCodeBook(this._pmf);
            StringToken[] codeBookTokens = new StringToken[this._pmf.length];
            int i2 = 0;
            while (i2 < this._pmf.length) {
                codeBookTokens[i2] = new StringToken(this._codeBook[i2]);
                ++i2;
            }
            this.huffmanCodeBook.send(0, (Token)new ArrayToken((Type)BaseType.STRING, (Token[])codeBookTokens));
        }
    }

    public String[] generateCodeBook(double[] pmf) {
        String[] codeBook = new String[pmf.length];
        LinkedList<Node> list = new LinkedList<Node>();
        int i = 0;
        while (i < this._pmf.length) {
            Node node = new Node(this._pmf[i], i);
            list.add(node);
            ++i;
        }
        while (list.size() > 1) {
            Node node1 = this._findMinNode(list);
            list.remove(node1);
            Node node2 = this._findMinNode(list);
            list.remove(node2);
            Node newNode = new Node(node2, node1);
            list.add(newNode);
        }
        Node root = (Node)list.get(0);
        root.huffmanCode = "";
        this._setCode(root, codeBook);
        return codeBook;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._parametersInvalid = true;
    }

    private Node _findMinNode(LinkedList list) {
        double minProb = ((Node)list.get((int)0)).probability;
        int index = 0;
        int i = 1;
        while (i < list.size()) {
            if (((Node)list.get((int)i)).probability < minProb) {
                index = i;
                minProb = ((Node)list.get((int)i)).probability;
            }
            ++i;
        }
        return (Node)list.get(index);
    }

    private void _setCode(Node node, String[] codeBook) {
        Node right;
        String parentCode = node.huffmanCode;
        Node left = node.leftChild;
        if (left != null) {
            String leftCode;
            left.huffmanCode = leftCode = String.valueOf(parentCode) + "0";
            if (left.indexInArray >= 0) {
                codeBook[left.indexInArray] = leftCode;
            } else {
                this._setCode(left, codeBook);
            }
        }
        if ((right = node.rightChild) != null) {
            String rightCode;
            right.huffmanCode = rightCode = String.valueOf(parentCode) + "1";
            if (right.indexInArray >= 0) {
                codeBook[right.indexInArray] = rightCode;
            } else {
                this._setCode(right, codeBook);
            }
        }
    }

    public static class Node {
        public double probability;
        public int indexInArray;
        public Node leftChild;
        public Node rightChild;
        public String huffmanCode;

        public Node(double prob, int index) {
            this.probability = prob;
            this.indexInArray = index;
            this.leftChild = null;
            this.rightChild = null;
            this.huffmanCode = "";
        }

        public Node(Node left, Node right) {
            this.probability = left.probability + right.probability;
            this.indexInArray = -1;
            this.leftChild = left;
            this.rightChild = right;
            this.huffmanCode = "";
        }
    }
}

