/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class HammingCoder
extends Transformer {
    public Parameter uncodedRate = new Parameter((NamedObj)this, "uncodedRate");
    public Parameter codedRate;
    private Parameter _inputRate;
    private Parameter _outputRate;
    private int _uncodeSizeValue;
    private int _codeSizeValue;
    private int _order;
    private int[][] _parityMatrix;
    private transient boolean _parameterInvalid = true;

    public HammingCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.uncodedRate.setTypeEquals((Type)BaseType.INT);
        this.uncodedRate.setExpression("4");
        this.codedRate = new Parameter((NamedObj)this, "codedRate");
        this.codedRate.setTypeEquals((Type)BaseType.INT);
        this.codedRate.setExpression("7");
        this.input.setTypeEquals((Type)BaseType.BOOLEAN);
        this._inputRate = new Parameter((NamedObj)this.input, "tokenConsumptionRate", (Token)new IntToken(1));
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
        this._outputRate = new Parameter((NamedObj)this.output, "tokenProductionRate", (Token)new IntToken(1));
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.codedRate) {
            this._codeSizeValue = ((IntToken)this.codedRate.getToken()).intValue();
            if (this._codeSizeValue <= 0) {
                throw new IllegalActionException((Nameable)this, "codedRate must be positive.");
            }
            this._outputRate.setToken((Token)new IntToken(this._codeSizeValue));
        } else if (attribute == this.uncodedRate) {
            this._uncodeSizeValue = ((IntToken)this.uncodedRate.getToken()).intValue();
            if (this._uncodeSizeValue < 1) {
                throw new IllegalActionException((Nameable)this, "uncodedRate must be non-negative.");
            }
            this._parameterInvalid = true;
            this._inputRate.setToken((Token)new IntToken(this._uncodeSizeValue));
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        int i;
        super.fire();
        if (this._parameterInvalid) {
            if (this._uncodeSizeValue >= this._codeSizeValue) {
                throw new IllegalActionException((Nameable)this, "codedRate must be greater than uncodedRate.");
            }
            this._order = this._codeSizeValue - this._uncodeSizeValue;
            if (this._codeSizeValue != (1 << this._order) - 1) {
                throw new IllegalActionException((Nameable)this, "Invalid pair of uncodedRate and codedRate.");
            }
            this._parityMatrix = new int[this._uncodeSizeValue][this._order];
            int flag = 0;
            int index = 0;
            i = 1;
            while (i <= this._codeSizeValue) {
                if (i == 1 << flag) {
                    ++flag;
                } else {
                    int j = 0;
                    while (j < this._order) {
                        this._parityMatrix[index][j] = i >> this._order - j - 1 & 1;
                        ++j;
                    }
                    ++index;
                }
                ++i;
            }
            this._parameterInvalid = false;
        }
        Token[] inputToken = this.input.get(0, this._uncodeSizeValue);
        BooleanToken[] result = new BooleanToken[this._codeSizeValue];
        i = 0;
        while (i < this._uncodeSizeValue) {
            result[i] = (BooleanToken)inputToken[i];
            ++i;
        }
        int[] parity = new int[this._order];
        int i2 = 0;
        while (i2 < this._order) {
            parity[i2] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < this._uncodeSizeValue) {
            int j = 0;
            while (j < this._order) {
                parity[j] = parity[j] ^ (result[i2].booleanValue() ? 1 : 0) & this._parityMatrix[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this._order) {
            result[i2 + this._uncodeSizeValue] = new BooleanToken(parity[i2] == 1);
            ++i2;
        }
        this.output.broadcast((Token[])result, result.length);
    }
}

