/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.LfToCrLfFilterOutputStream;
import org.apache.sshd.common.util.LoggingFilterOutputStream;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.ServerChannel;
import org.apache.sshd.server.ShellFactory;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.session.ServerSession;

public class ChannelSession
extends AbstractServerChannel {
    protected String type;
    protected PtyModeValue[] ptyModes;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ShellFactory.Shell shell;
    protected OutputStream shellIn;
    protected InputStream shellOut;
    protected InputStream shellErr;
    protected StandardEnvironment env = new StandardEnvironment();

    public CloseFuture close(boolean immediately) {
        return (CloseFuture)super.close(immediately).addListener(new SshFutureListener(){

            public void operationComplete(SshFuture sshFuture) {
                if (ChannelSession.this.shell != null) {
                    ChannelSession.this.shell.destroy();
                    ChannelSession.this.shell = null;
                }
                ChannelSession.this.remoteWindow.notifyClosed();
                IoUtils.closeQuietly(ChannelSession.this.in, ChannelSession.this.out, ChannelSession.this.err, ChannelSession.this.shellIn, ChannelSession.this.shellOut, ChannelSession.this.shellErr);
            }
        });
    }

    public void handleEof() throws IOException {
        super.handleEof();
        this.shellIn.close();
    }

    public void handleRequest(Buffer buffer) throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_REQUEST on channel {}", (Object)this.id);
        String type = buffer.getString();
        this.log.info("Received channel request: {}", (Object)type);
        if (!this.handleRequest(type, buffer)) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        this.shellIn.write(data, off, len);
        this.shellIn.flush();
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Server channel does not support extended data");
    }

    protected boolean handleRequest(String type, Buffer buffer) throws IOException {
        if ("env".equals(type)) {
            return this.handleEnv(buffer);
        }
        if ("pty-req".equals(type)) {
            return this.handlePtyReq(buffer);
        }
        if ("window-change".equals(type)) {
            return this.handleWindowChange(buffer);
        }
        if ("signal".equals(type)) {
            return this.handleSignal(buffer);
        }
        if ("shell".equals(type)) {
            if (this.checkType(type)) {
                return this.handleShell(buffer);
            }
            return false;
        }
        if ("exec".equals(type)) {
            if (this.checkType(type)) {
                return this.handleExec(buffer);
            }
            return false;
        }
        if ("subsystem".equals(type)) {
            if (this.checkType(type)) {
                return this.handleSubsystem(buffer);
            }
            return false;
        }
        if ("auth-agent-req@openssh.com".equals(type)) {
            return this.handleAgentForwarding(buffer);
        }
        if ("x11-req".equals(type)) {
            return this.handleX11Forwarding(buffer);
        }
        return false;
    }

    private boolean checkType(String type) {
        if (this.type == null) {
            this.type = type;
            return true;
        }
        return false;
    }

    protected boolean handleEnv(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String name = buffer.getString();
        String value = buffer.getString();
        this.addEnvVariable(name, value);
        this.log.debug("env for channel {}: {} = {}", new Object[]{this.id, name, value});
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handlePtyReq(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String term = buffer.getString();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        byte[] modes = buffer.getBytes();
        ArrayList<PtyModeValue> modeList = new ArrayList<PtyModeValue>();
        int i = 0;
        while (i < modes.length && modes[i] != 0) {
            PtyMode mode = PtyMode.fromInt(modes[i++]);
            int val = modes[i++] << 24 & 0xFF000000 | modes[i++] << 16 & 0xFF0000 | modes[i++] << 8 & 0xFF00 | modes[i++] & 0xFF;
            PtyModeValue m = new PtyModeValue(mode, val);
            modeList.add(m);
        }
        this.ptyModes = modeList.toArray(new PtyModeValue[0]);
        if (this.log.isDebugEnabled()) {
            StringBuffer strModes = new StringBuffer();
            for (PtyModeValue m : this.ptyModes) {
                if (strModes.length() > 0) {
                    strModes.append(", ");
                }
                strModes.append(m);
            }
            this.log.debug("pty for channel {}: term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this.id, term, tColumns, tRows, tWidth, tHeight, strModes.toString()});
        }
        this.addEnvVariable("TERM", term);
        this.addEnvVariable("COLUMNS", Integer.toString(tColumns));
        this.addEnvVariable("LINES", Integer.toString(tRows));
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleWindowChange(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        this.log.debug("window-change for channel {}: ({} - {}), ({}, {})", new Object[]{this.id, tColumns, tRows, tWidth, tHeight});
        StandardEnvironment e = this.getEnvironment();
        e.set("COLUMNS", Integer.toString(tColumns));
        e.set("LINES", Integer.toString(tRows));
        e.signal(28);
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleSignal(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String name = buffer.getString();
        this.log.debug("Signal received on channel {}: {}", (Object)this.id, (Object)name);
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleShell(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        if (((ServerSession)this.session).getServerFactoryManager().getShellFactory() == null) {
            return false;
        }
        this.addEnvVariable("USER", ((ServerSession)this.session).getUsername());
        this.shell = ((ServerSession)this.session).getServerFactoryManager().getShellFactory().createShell();
        if (this.shell instanceof ShellFactory.SessionAware) {
            ((ShellFactory.SessionAware)((Object)this.shell)).setSession((ServerSession)this.session);
        }
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        this.err = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_EXTENDED_DATA);
        this.out = new LoggingFilterOutputStream(this.out, "OUT:", this.log);
        this.err = new LoggingFilterOutputStream(this.err, "ERR:", this.log);
        if (this.getPtyModeValue(PtyMode.ONLCR) != 0) {
            this.out = new LfToCrLfFilterOutputStream(this.out);
            this.err = new LfToCrLfFilterOutputStream(this.err);
        }
        this.in = new ChannelPipedInputStream(this.localWindow);
        this.shellIn = new ChannelPipedOutputStream((ChannelPipedInputStream)this.in);
        this.shell.setInputStream(this.in);
        this.shell.setOutputStream(this.out);
        this.shell.setErrorStream(this.err);
        this.shell.setExitCallback(new ShellFactory.ExitCallback(){

            public void onExit(int exitValue) {
                try {
                    ChannelSession.this.closeShell(exitValue);
                }
                catch (IOException e) {
                    ChannelSession.this.log.info("Error closing shell", (Throwable)e);
                }
            }
        });
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        this.shell.start(this.getEnvironment());
        this.shellIn = new LoggingFilterOutputStream(this.shellIn, "IN: ", this.log);
        return true;
    }

    protected int getPtyModeValue(PtyMode mode) {
        if (this.ptyModes != null) {
            for (PtyModeValue m : this.ptyModes) {
                if (m.mode != mode) continue;
                return m.value;
            }
        }
        return 0;
    }

    protected boolean handleExec(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String commandLine = buffer.getString();
        if (((ServerSession)this.session).getServerFactoryManager().getCommandFactory() == null) {
            return false;
        }
        CommandFactory.Command command = ((ServerSession)this.session).getServerFactoryManager().getCommandFactory().createCommand(commandLine);
        if (command instanceof CommandFactory.SessionAware) {
            ((CommandFactory.SessionAware)((Object)command)).setSession((ServerSession)this.session);
        }
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        this.err = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_EXTENDED_DATA);
        this.out = new LoggingFilterOutputStream(this.out, "OUT:", this.log);
        this.err = new LoggingFilterOutputStream(this.err, "ERR:", this.log);
        this.in = new ChannelPipedInputStream(this.localWindow);
        this.shellIn = new ChannelPipedOutputStream((ChannelPipedInputStream)this.in);
        command.setInputStream(this.in);
        command.setOutputStream(this.out);
        command.setErrorStream(this.err);
        command.setExitCallback(new CommandFactory.ExitCallback(){

            public void onExit(int exitValue) {
                try {
                    ChannelSession.this.closeShell(exitValue);
                }
                catch (IOException e) {
                    ChannelSession.this.log.info("Error closing shell", (Throwable)e);
                }
            }
        });
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        command.start();
        return true;
    }

    protected boolean handleSubsystem(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleAgentForwarding(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleX11Forwarding(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected void addEnvVariable(String name, String value) {
        this.getEnvironment().set(name, value);
    }

    protected StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int exitValue) throws IOException {
        this.sendEof();
        this.sendExitStatus(exitValue);
        this.close(false);
    }

    protected static class PtyModeValue {
        public final PtyMode mode;
        public final int value;

        public PtyModeValue(PtyMode mode, int value) {
            this.mode = mode;
            this.value = value;
        }

        public String toString() {
            return (Object)((Object)this.mode) + "(" + this.mode.toInt() + ") =" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PtyMode {
        VINTR(1),
        VQUIT(2),
        VERASE(3),
        VKILL(4),
        VEOF(5),
        VEOL(6),
        VEOL2(7),
        VSTART(8),
        VSTOP(9),
        VSUSP(10),
        VDSUSP(11),
        VREPRINT(12),
        VWERASE(13),
        VLNEXT(14),
        VFLUSH(15),
        VSWTCH(16),
        VSTATUS(17),
        VDISCARD(18),
        IGNPAR(30),
        PARMRK(31),
        INPCK(32),
        ISTRIP(33),
        INCLR(34),
        IGNCR(35),
        ICRNL(36),
        IUCLC(37),
        IXON(38),
        IXANY(39),
        IXOFF(40),
        IMAXBEL(41),
        ISIG(50),
        ICANON(51),
        XCASE(52),
        ECHO(53),
        ECHOE(54),
        ECHOK(55),
        ECHONL(56),
        NOFLSH(57),
        TOSTOP(58),
        IEXTEN(59),
        ECHOCTL(60),
        ECHOKE(61),
        PENDIN(62),
        OPOST(70),
        OLCUC(71),
        ONLCR(72),
        OCRNL(73),
        ONOCR(74),
        ONLRET(75),
        CS7(90),
        CS8(91),
        PARENB(92),
        PARODD(93),
        TTY_OP_ISPEED(128),
        TTY_OP_OSPEED(129);

        private int v;
        static Map<Integer, PtyMode> commands;

        private PtyMode(int v) {
            this.v = v;
        }

        public int toInt() {
            return this.v;
        }

        public static PtyMode fromInt(int b) {
            return commands.get(0xFF & b + 256);
        }

        static {
            commands = new HashMap<Integer, PtyMode>();
            for (PtyMode c : PtyMode.values()) {
                commands.put(c.toInt(), c);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StandardEnvironment
    implements ShellFactory.Environment {
        private final Map<Integer, List<ShellFactory.SignalListener>> qualifiedListeners = new ConcurrentHashMap<Integer, List<ShellFactory.SignalListener>>(3);
        private final List<ShellFactory.SignalListener> listeners = this.createSignalListenerList();
        private final Map<String, String> env = new ConcurrentHashMap<String, String>();

        protected CopyOnWriteArrayList<ShellFactory.SignalListener> createSignalListenerList() {
            return new CopyOnWriteArrayList<ShellFactory.SignalListener>();
        }

        @Override
        public void addSignalListener(int signal, ShellFactory.SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            this.getSignalListenersList(signal, true).add(listener);
        }

        @Override
        public void addSignalListener(ShellFactory.SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            this.getSignalListenersList().add(listener);
        }

        @Override
        public Map<String, String> getEnv() {
            return this.env;
        }

        @Override
        public void removeSignalListener(int signal, ShellFactory.SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            List<ShellFactory.SignalListener> ls = this.getSignalListenersList(signal, false);
            if (ls != null) {
                ls.remove(listener);
            }
        }

        @Override
        public void removeSignalListener(ShellFactory.SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            this.getSignalListenersList().remove(listener);
        }

        public void signal(int signal) {
            List<ShellFactory.SignalListener> qls = this.getSignalListenersList(signal, false);
            List<ShellFactory.SignalListener> ls = this.getSignalListenersList();
            if (qls != null) {
                for (ShellFactory.SignalListener l : qls) {
                    l.signal(signal);
                }
            }
            for (ShellFactory.SignalListener l : ls) {
                l.signal(signal);
            }
        }

        public void set(String key, String value) {
            this.getEnv().put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<ShellFactory.SignalListener> getSignalListenersList(int signal, boolean create) {
            List<ShellFactory.SignalListener> ls = this.qualifiedListeners.get(signal);
            if (ls == null && create) {
                Map<Integer, List<ShellFactory.SignalListener>> map = this.qualifiedListeners;
                synchronized (map) {
                    ls = this.createSignalListenerList();
                    this.qualifiedListeners.put(signal, ls);
                }
            }
            return ls;
        }

        protected List<ShellFactory.SignalListener> getSignalListenersList() {
            return this.listeners;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<ServerChannel> {
        @Override
        public String getName() {
            return "session";
        }

        @Override
        public ServerChannel create() {
            return new ChannelSession();
        }
    }
}

