/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.ServerChannel;
import org.apache.sshd.server.session.ServerSession;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    protected boolean exitStatusSent;

    public void init(ServerSession session, int id, int recipient, int rwsize, int rmpsize) {
        this.session = session;
        this.id = id;
        this.recipient = recipient;
        this.remoteWindow.init(rwsize, rmpsize);
        this.configureWindow();
    }

    protected void sendExitStatus(int v) throws IOException {
        if (!this.exitStatusSent) {
            this.exitStatusSent = true;
            this.log.info("Send SSH_MSG_CHANNEL_REQUEST exit-status on channel {}", (Object)this.id);
            Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_REQUEST);
            buffer.putInt(this.recipient);
            buffer.putString("exit-status");
            buffer.putByte((byte)0);
            buffer.putInt(v);
            this.session.writePacket(buffer);
        }
    }
}

